/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.imageio.codec;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import org.dcm4che3.imageio.codec.FormatNameFilterIterator;
import org.dcm4che3.imageio.codec.jpeg.PatchJPEGLS;
import org.dcm4che3.util.Property;
import org.dcm4che3.util.ResourceLocator;
import org.dcm4che3.util.SafeClose;
import org.dcm4che3.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageReaderFactory
implements Serializable {
    private static final long serialVersionUID = -2881173333124498212L;
    private static final Logger LOG = LoggerFactory.getLogger(ImageReaderFactory.class);
    private static volatile ImageReaderFactory defaultFactory;
    private final TreeMap<String, ImageReaderParam> map = new TreeMap();

    private static String nullify(String s) {
        return s == null || s.isEmpty() || s.equals("*") ? null : s;
    }

    public static ImageReaderFactory getDefault() {
        if (defaultFactory == null) {
            defaultFactory = ImageReaderFactory.initDefault();
        }
        return defaultFactory;
    }

    public static void resetDefault() {
        defaultFactory = null;
    }

    public static void setDefault(ImageReaderFactory factory) {
        if (factory == null) {
            throw new NullPointerException();
        }
        defaultFactory = factory;
    }

    private static ImageReaderFactory initDefault() {
        ImageReaderFactory factory = new ImageReaderFactory();
        String name = System.getProperty(ImageReaderFactory.class.getName(), "org/dcm4che3/imageio/codec/ImageReaderFactory.properties");
        try {
            factory.load(name);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load Image Reader Factory configuration from: " + name, e);
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String name) throws IOException {
        URL url;
        block5: {
            try {
                url = new URL(name);
            }
            catch (MalformedURLException e) {
                url = ResourceLocator.getResourceURL((String)name, this.getClass());
                if (url != null) break block5;
                throw new IOException("No such resource: " + name);
            }
        }
        InputStream in = url.openStream();
        try {
            this.load(in);
        }
        finally {
            SafeClose.close((Closeable)in);
        }
    }

    public void load(InputStream in) throws IOException {
        Properties props = new Properties();
        props.load(in);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String[] ss = StringUtils.split((String)((String)entry.getValue()), (char)':');
            this.map.put((String)entry.getKey(), new ImageReaderParam(ss[0], ss[1], ss[2], ss.length > 3 ? StringUtils.split((String)ss[3], (char)';') : StringUtils.EMPTY_STRING));
        }
    }

    public ImageReaderParam get(String tsuid) {
        return this.map.get(tsuid);
    }

    public boolean contains(String tsuid) {
        return this.map.containsKey(tsuid);
    }

    public ImageReaderParam put(String tsuid, ImageReaderParam param) {
        return this.map.put(tsuid, param);
    }

    public ImageReaderParam remove(String tsuid) {
        return this.map.remove(tsuid);
    }

    public Set<Map.Entry<String, ImageReaderParam>> getEntries() {
        return Collections.unmodifiableMap(this.map).entrySet();
    }

    public void clear() {
        this.map.clear();
    }

    public static ImageReaderParam getImageReaderParam(String tsuid) {
        return ImageReaderFactory.getDefault().get(tsuid);
    }

    public static boolean canDecompress(String tsuid) {
        return ImageReaderFactory.getDefault().contains(tsuid);
    }

    public static ImageReader getImageReader(ImageReaderParam param) {
        return Boolean.getBoolean("org.dcm4che3.imageio.codec.useServiceLoader") ? ImageReaderFactory.getImageReaderFromServiceLoader(param) : ImageReaderFactory.getImageReaderFromImageIOServiceRegistry(param);
    }

    public static ImageReader getImageReaderFromImageIOServiceRegistry(ImageReaderParam param) {
        Iterator<ImageReader> iter = ImageIO.getImageReadersByFormatName(param.formatName);
        if (!iter.hasNext()) {
            throw new RuntimeException("No Reader for format: " + param.formatName + " registered");
        }
        ImageReader reader = iter.next();
        if (param.className != null) {
            while (!param.className.equals(reader.getClass().getName())) {
                if (iter.hasNext()) {
                    reader = iter.next();
                    continue;
                }
                LOG.warn("No preferred Reader {} for format: {} - use {}", new Object[]{param.className, param.formatName, reader.getClass().getName()});
                break;
            }
        }
        return reader;
    }

    public static ImageReader getImageReaderFromServiceLoader(ImageReaderParam param) {
        try {
            return ImageReaderFactory.getImageReaderSpi(param).createReaderInstance();
        }
        catch (IOException e) {
            throw new RuntimeException("Error instantiating Reader for format: " + param.formatName, e);
        }
    }

    private static ImageReaderSpi getImageReaderSpi(ImageReaderParam param) {
        FormatNameFilterIterator<ImageReaderSpi> iter = new FormatNameFilterIterator<ImageReaderSpi>(ServiceLoader.load(ImageReaderSpi.class).iterator(), param.formatName);
        if (!iter.hasNext()) {
            throw new RuntimeException("No Reader for format: " + param.formatName + " registered");
        }
        ImageReaderSpi spi = (ImageReaderSpi)iter.next();
        if (param.className != null) {
            while (!param.className.equals(spi.getPluginClassName())) {
                if (iter.hasNext()) {
                    spi = (ImageReaderSpi)iter.next();
                    continue;
                }
                LOG.warn("No preferred Reader {} for format: {} - use {}", new Object[]{param.className, param.formatName, spi.getPluginClassName()});
                break;
            }
        }
        return spi;
    }

    public static class ImageReaderParam
    implements Serializable {
        private static final long serialVersionUID = 6593724836340684578L;
        public final String formatName;
        public final String className;
        public final PatchJPEGLS patchJPEGLS;
        public final Property[] imageReadParams;

        public ImageReaderParam(String formatName, String className, PatchJPEGLS patchJPEGLS, Property[] imageReadParams) {
            this.formatName = formatName;
            this.className = ImageReaderFactory.nullify(className);
            this.patchJPEGLS = patchJPEGLS;
            this.imageReadParams = imageReadParams;
        }

        public ImageReaderParam(String formatName, String className, String patchJPEGLS, String ... imageWriteParams) {
            this(formatName, className, patchJPEGLS != null && !patchJPEGLS.isEmpty() ? PatchJPEGLS.valueOf(patchJPEGLS) : null, Property.valueOf((String[])imageWriteParams));
        }

        public Property[] getImageReadParams() {
            return this.imageReadParams;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImageReaderParam that = (ImageReaderParam)o;
            if (!this.formatName.equals(that.formatName)) {
                return false;
            }
            if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
                return false;
            }
            if (this.patchJPEGLS != that.patchJPEGLS) {
                return false;
            }
            return Arrays.equals(this.imageReadParams, that.imageReadParams);
        }

        public int hashCode() {
            int result = this.formatName.hashCode();
            result = 31 * result + (this.className != null ? this.className.hashCode() : 0);
            result = 31 * result + (this.patchJPEGLS != null ? this.patchJPEGLS.hashCode() : 0);
            result = 31 * result + Arrays.hashCode(this.imageReadParams);
            return result;
        }

        public String toString() {
            return "ImageReaderParam{formatName='" + this.formatName + '\'' + ", className='" + this.className + '\'' + ", patchJPEGLS=" + (Object)((Object)this.patchJPEGLS) + ", imageReadParams=" + Arrays.toString(this.imageReadParams) + '}';
        }
    }
}

