#!/bin/bash

# Create data directory.
if [ ! -e "data" ] ; then
  echo "Create ./data/ directory for input files"
  mkdir -p data
  echo " ... created."
  echo
  echo "Please, place your data to the ./data/ directory and"
  echo "re-run the command ./anonmed.sh again to de-identify them."
  echo "De-identified files will be created in the ./output/ directory."
  echo 
  echo "Note: This information is shown only when the ./data/ directory is missing."
  exit 0;
fi

# Create output directory.
if [ ! -e "output" ] ; then
  echo "Create ./output/ directory for de-identified files."
  mkdir -p output
fi

# Create output directory.
if [ ! -e "output-uncertain" ] ; then
  echo "Create ./output-uncertain/ directory for output files that may be not de-identified."
  mkdir -p output-uncertain
fi

# Create initial sequence number.
if [ ! -e "conf/sequence" ] ; then
  echo "Initialized sequence number to 1."
  echo "1" > conf/sequence
fi

# Touch/Create identification map database.
if [ ! -e "conf/identification.map" ] ; then
  echo "Initialized de-identification map."
  touch conf/identification.map
fi

APP_JAR=`ls -1 anonmed-*.jar| grep -v -e javadoc -e sources | sort | tail -n 1`

#java $LOG_CONFIG -cp ./ -jar ${APP_JAR} --profiles conf/profile --identification-mapping conf/identification.map --sequence-number conf/sequence --output output/ --uncertain output-uncertain/ data/ $@

java -cp ./ -jar ${APP_JAR} --profiles conf/profile --identification-mapping conf/identification.map --sequence-number conf/sequence --output output/ --uncertain output-uncertain/ data/ $@

### EOF