/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jena.driver;

import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.ModelCom;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.shared.JenaException;
import virtuoso.jena.driver.VirtGraph;
import virtuoso.jena.driver.VirtStreamRDF;

public class VirtModel
extends ModelCom {
    public VirtModel(VirtGraph base) {
        super((Graph)base);
    }

    public static VirtModel openDefaultModel(ConnectionPoolDataSource ds) {
        return new VirtModel(new VirtGraph(ds));
    }

    public static VirtModel openDatabaseModel(String graphName, ConnectionPoolDataSource ds) {
        return new VirtModel(new VirtGraph(graphName, ds));
    }

    public static VirtModel openDefaultModel(DataSource ds) {
        return new VirtModel(new VirtGraph(ds));
    }

    public static VirtModel openDatabaseModel(String graphName, DataSource ds) {
        return new VirtModel(new VirtGraph(graphName, ds));
    }

    public static VirtModel openDefaultModel(String url, String user, String password) {
        return new VirtModel(new VirtGraph(url, user, password));
    }

    public static VirtModel openDatabaseModel(String graphName, String url, String user, String password) {
        return new VirtModel(new VirtGraph(graphName, url, user, password));
    }

    public Model removeAll() {
        try {
            VirtGraph _graph = (VirtGraph)this.graph;
            _graph.clear();
        }
        catch (ClassCastException e) {
            super.removeAll();
        }
        return this;
    }

    public StreamRDF getStreamRDF(boolean useAutoCommit, int chunkSize, VirtStreamRDF.DeadLockHandler dhandler) {
        return new VirtStreamRDF(this, useAutoCommit, chunkSize, dhandler);
    }

    public void createRuleSet(String ruleSetName, String uriGraphRuleSet) {
        ((VirtGraph)this.graph).createRuleSet(ruleSetName, uriGraphRuleSet);
    }

    public void removeRuleSet(String ruleSetName, String uriGraphRuleSet) {
        ((VirtGraph)this.graph).removeRuleSet(ruleSetName, uriGraphRuleSet);
    }

    public void setRuleSet(String _ruleSet) {
        ((VirtGraph)this.graph).setRuleSet(_ruleSet);
    }

    public void setSameAs(boolean _sameAs) {
        ((VirtGraph)this.graph).setSameAs(_sameAs);
    }

    public void setMacroLib(String _macroLib) {
        ((VirtGraph)this.graph).setMacroLib(_macroLib);
    }

    public int getBatchSize() {
        return ((VirtGraph)this.graph).getBatchSize();
    }

    public void setBatchSize(int sz) {
        ((VirtGraph)this.graph).setBatchSize(sz);
    }

    public String getSparqlPrefix() {
        return ((VirtGraph)this.graph).getSparqlPrefix();
    }

    public void setSparqlPrefix(String val) {
        ((VirtGraph)this.graph).setSparqlPrefix(val);
    }

    public boolean getInsertBNodeAsVirtuosoIRI() {
        return ((VirtGraph)this.graph).getInsertBNodeAsVirtuosoIRI();
    }

    public void setInsertBNodeAsVirtuosoIRI(boolean v) {
        ((VirtGraph)this.graph).setInsertBNodeAsVirtuosoIRI(v);
    }

    public boolean getResetBNodesDictAfterCall() {
        return ((VirtGraph)this.graph).getResetBNodesDictAfterCall();
    }

    public void setResetBNodesDictAfterCall(boolean v) {
        ((VirtGraph)this.graph).setResetBNodesDictAfterCall(v);
    }

    public boolean getResetBNodesDictAfterCommit() {
        return ((VirtGraph)this.graph).getResetBNodesDictAfterCommit();
    }

    public void setResetBNodesDictAfterCommit(boolean v) {
        ((VirtGraph)this.graph).setResetBNodesDictAfterCommit(v);
    }

    public boolean getInsertStringLiteralAsSimple() {
        return ((VirtGraph)this.graph).getInsertStringLiteralAsSimple();
    }

    public void setInsertStringLiteralAsSimple(boolean v) {
        ((VirtGraph)this.graph).setInsertStringLiteralAsSimple(v);
    }

    public void setConcurrencyMode(int mode) throws JenaException {
        ((VirtGraph)this.graph).setConcurrencyMode(mode);
    }

    public int getConcurrencyMode() {
        return ((VirtGraph)this.graph).concurencyMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model read(String url) {
        VirtGraph g = (VirtGraph)this.getGraph();
        Object object = g.lck_add;
        synchronized (object) {
            Model model;
            try {
                g.startBatchAdd();
            }
            catch (Exception e) {
                throw new JenaException((Throwable)e);
            }
            try {
                Model ret;
                model = ret = super.read(url);
            }
            catch (Throwable throwable) {
                try {
                    g.stopBatchAdd();
                }
                catch (Exception e) {
                    throw new JenaException((Throwable)e);
                }
                throw throwable;
            }
            try {
                g.stopBatchAdd();
            }
            catch (Exception e) {
                throw new JenaException((Throwable)e);
            }
            return model;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model read(Reader reader, String base) {
        VirtGraph g = (VirtGraph)this.getGraph();
        Object object = g.lck_add;
        synchronized (object) {
            Model model;
            try {
                g.startBatchAdd();
            }
            catch (Exception e) {
                throw new JenaException((Throwable)e);
            }
            try {
                Model ret;
                model = ret = super.read(reader, base);
            }
            catch (Throwable throwable) {
                try {
                    g.stopBatchAdd();
                }
                catch (Exception e) {
                    throw new JenaException((Throwable)e);
                }
                throw throwable;
            }
            try {
                g.stopBatchAdd();
            }
            catch (Exception e) {
                throw new JenaException((Throwable)e);
            }
            return model;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model read(InputStream reader, String base) {
        VirtGraph g = (VirtGraph)this.getGraph();
        Object object = g.lck_add;
        synchronized (object) {
            Model model;
            try {
                g.startBatchAdd();
            }
            catch (Exception e) {
                throw new JenaException((Throwable)e);
            }
            try {
                Model ret;
                model = ret = super.read(reader, base);
            }
            catch (Throwable throwable) {
                try {
                    g.stopBatchAdd();
                }
                catch (Exception e) {
                    throw new JenaException((Throwable)e);
                }
                throw throwable;
            }
            try {
                g.stopBatchAdd();
            }
            catch (Exception e) {
                throw new JenaException((Throwable)e);
            }
            return model;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model read(String url, String lang) {
        VirtGraph g = (VirtGraph)this.getGraph();
        Object object = g.lck_add;
        synchronized (object) {
            Model model;
            try {
                g.startBatchAdd();
            }
            catch (Exception e) {
                throw new JenaException((Throwable)e);
            }
            try {
                Model ret;
                model = ret = super.read(url, lang);
            }
            catch (Throwable throwable) {
                try {
                    g.stopBatchAdd();
                }
                catch (Exception e) {
                    throw new JenaException((Throwable)e);
                }
                throw throwable;
            }
            try {
                g.stopBatchAdd();
            }
            catch (Exception e) {
                throw new JenaException((Throwable)e);
            }
            return model;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model read(String url, String base, String lang) {
        VirtGraph g = (VirtGraph)this.getGraph();
        Object object = g.lck_add;
        synchronized (object) {
            Model model;
            try {
                g.startBatchAdd();
            }
            catch (Exception e) {
                throw new JenaException((Throwable)e);
            }
            try {
                Model ret;
                model = ret = super.read(url, base, lang);
            }
            catch (Throwable throwable) {
                try {
                    g.stopBatchAdd();
                }
                catch (Exception e) {
                    throw new JenaException((Throwable)e);
                }
                throw throwable;
            }
            try {
                g.stopBatchAdd();
            }
            catch (Exception e) {
                throw new JenaException((Throwable)e);
            }
            return model;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model read(Reader reader, String base, String lang) {
        VirtGraph g = (VirtGraph)this.getGraph();
        Object object = g.lck_add;
        synchronized (object) {
            Model model;
            try {
                g.startBatchAdd();
            }
            catch (Exception e) {
                throw new JenaException((Throwable)e);
            }
            try {
                Model ret;
                model = ret = super.read(reader, base, lang);
            }
            catch (Throwable throwable) {
                try {
                    g.stopBatchAdd();
                }
                catch (Exception e) {
                    throw new JenaException((Throwable)e);
                }
                throw throwable;
            }
            try {
                g.stopBatchAdd();
            }
            catch (Exception e) {
                throw new JenaException((Throwable)e);
            }
            return model;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model read(InputStream reader, String base, String lang) {
        VirtGraph g = (VirtGraph)this.getGraph();
        Object object = g.lck_add;
        synchronized (object) {
            Model model;
            try {
                g.startBatchAdd();
            }
            catch (Exception e) {
                throw new JenaException((Throwable)e);
            }
            try {
                Model ret;
                model = ret = super.read(reader, base, lang);
            }
            catch (Throwable throwable) {
                try {
                    g.stopBatchAdd();
                }
                catch (Exception e) {
                    throw new JenaException((Throwable)e);
                }
                throw throwable;
            }
            try {
                g.stopBatchAdd();
            }
            catch (Exception e) {
                throw new JenaException((Throwable)e);
            }
            return model;
        }
    }

    public Model add(Statement[] statements) {
        return this.add(Arrays.asList(statements).iterator());
    }

    public Model add(List<Statement> statements) {
        return this.add(statements.iterator());
    }

    public Model add(StmtIterator iter) {
        return this.add((Iterator<Statement>)iter);
    }

    protected Model add(Iterator<Statement> it) {
        VirtGraph g = (VirtGraph)this.graph;
        g.add(g.getGraphName(), it);
        return this;
    }

    public Model add(Model m) {
        return this.add(m.listStatements());
    }

    public Model remove(Statement[] statements) {
        return this.remove(Arrays.asList(statements).iterator());
    }

    public Model remove(List<Statement> statements) {
        return this.remove(statements.iterator());
    }

    protected Model remove(Iterator<Statement> it) {
        VirtGraph g = (VirtGraph)this.graph;
        g.delete(g.getGraphName(), it);
        return this;
    }

    public Model remove(Model m) {
        VirtGraph g = (VirtGraph)this.graph;
        g.md_delete_Model(m.listStatements());
        return this;
    }

    public Model begin(ReadWrite readWrite) {
        ((VirtGraph)this.getGraph()).getTransactionHandler().begin(readWrite);
        return this;
    }
}

