/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import virtuoso.jdbc4.Closeable;
import virtuoso.jdbc4.ConnectionWrapper;
import virtuoso.jdbc4.StatementWrapper;
import virtuoso.jdbc4.VirtuosoException;

public class ResultSetWrapper
implements ResultSet,
Closeable {
    private ConnectionWrapper wconn;
    private StatementWrapper wstmt;
    private volatile ResultSet rs;

    protected ResultSetWrapper(ConnectionWrapper _wconn, StatementWrapper _wstmt, ResultSet _rs) {
        this.wconn = _wconn;
        this.wstmt = _wstmt;
        this.rs = _rs;
        this.wstmt.addObjToClose(this);
    }

    protected ResultSetWrapper(ConnectionWrapper _wconn, ResultSet _rs) {
        this.wconn = _wconn;
        this.wstmt = null;
        this.rs = _rs;
        this.wconn.addObjToClose(this);
    }

    private void exceptionOccurred(SQLException sqlEx) {
        if (this.wconn != null) {
            this.wconn.exceptionOccurred(sqlEx);
        }
    }

    public void finalize() throws Throwable {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (this.rs == null) {
            return;
        }
        this.check_close();
        ResultSetWrapper resultSetWrapper = this;
        synchronized (resultSetWrapper) {
            try {
                this.rs.close();
                if (this.wstmt == null) {
                    this.wconn.removeObjFromClose(this);
                } else {
                    this.wstmt.removeObjFromClose(this);
                }
                this.rs = null;
                this.wstmt = null;
                this.wconn = null;
            }
            catch (SQLException ex) {
                this.exceptionOccurred(ex);
                throw ex;
            }
        }
    }

    @Override
    public boolean next() throws SQLException {
        this.check_close();
        try {
            return this.rs.next();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.check_close();
        try {
            return this.rs.wasNull();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.check_close();
        try {
            return this.rs.getString(columnIndex);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.check_close();
        try {
            return this.rs.getBoolean(columnIndex);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.check_close();
        try {
            return this.rs.getByte(columnIndex);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.check_close();
        try {
            return this.rs.getShort(columnIndex);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.check_close();
        try {
            return this.rs.getInt(columnIndex);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.check_close();
        try {
            return this.rs.getLong(columnIndex);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.check_close();
        try {
            return this.rs.getFloat(columnIndex);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.check_close();
        try {
            return this.rs.getDouble(columnIndex);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.check_close();
        try {
            return this.rs.getBigDecimal(columnIndex, scale);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.check_close();
        try {
            return this.rs.getBytes(columnIndex);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.check_close();
        try {
            return this.rs.getDate(columnIndex);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.check_close();
        try {
            return this.rs.getTime(columnIndex);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.check_close();
        try {
            return this.rs.getTimestamp(columnIndex);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.check_close();
        try {
            return this.rs.getAsciiStream(columnIndex);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.check_close();
        try {
            return this.rs.getUnicodeStream(columnIndex);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.check_close();
        try {
            return this.rs.getBinaryStream(columnIndex);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public String getString(String columnName) throws SQLException {
        this.check_close();
        try {
            return this.rs.getString(columnName);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        this.check_close();
        try {
            return this.rs.getBoolean(columnName);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        this.check_close();
        try {
            return this.rs.getByte(columnName);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        this.check_close();
        try {
            return this.rs.getShort(columnName);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        this.check_close();
        try {
            return this.rs.getInt(columnName);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        this.check_close();
        try {
            return this.rs.getLong(columnName);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        this.check_close();
        try {
            return this.rs.getFloat(columnName);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        this.check_close();
        try {
            return this.rs.getDouble(columnName);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        this.check_close();
        try {
            return this.rs.getBigDecimal(columnName, scale);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        this.check_close();
        try {
            return this.rs.getBytes(columnName);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        this.check_close();
        try {
            return this.rs.getDate(columnName);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        this.check_close();
        try {
            return this.rs.getTime(columnName);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        this.check_close();
        try {
            return this.rs.getTimestamp(columnName);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        this.check_close();
        try {
            return this.rs.getAsciiStream(columnName);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        this.check_close();
        try {
            return this.rs.getUnicodeStream(columnName);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        this.check_close();
        try {
            return this.rs.getBinaryStream(columnName);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.check_close();
        try {
            return this.rs.getWarnings();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.check_close();
        try {
            this.rs.clearWarnings();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        this.check_close();
        try {
            return this.rs.getCursorName();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.check_close();
        try {
            return this.rs.getMetaData();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.check_close();
        try {
            return this.rs.getObject(columnIndex);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        this.check_close();
        try {
            return this.rs.getObject(columnName);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        this.check_close();
        try {
            return this.rs.findColumn(columnName);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.check_close();
        try {
            return this.rs.getCharacterStream(columnIndex);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        this.check_close();
        try {
            return this.rs.getCharacterStream(columnName);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.check_close();
        try {
            return this.rs.getBigDecimal(columnIndex);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        this.check_close();
        try {
            return this.rs.getBigDecimal(columnName);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.check_close();
        try {
            return this.rs.isBeforeFirst();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.check_close();
        try {
            return this.rs.isAfterLast();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.check_close();
        try {
            return this.rs.isFirst();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public boolean isLast() throws SQLException {
        this.check_close();
        try {
            return this.rs.isLast();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.check_close();
        try {
            this.rs.beforeFirst();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void afterLast() throws SQLException {
        this.check_close();
        try {
            this.rs.afterLast();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public boolean first() throws SQLException {
        this.check_close();
        try {
            return this.rs.first();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public boolean last() throws SQLException {
        this.check_close();
        try {
            return this.rs.last();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public int getRow() throws SQLException {
        this.check_close();
        try {
            return this.rs.getRow();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.check_close();
        try {
            return this.rs.absolute(row);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public boolean relative(int row) throws SQLException {
        this.check_close();
        try {
            return this.rs.relative(row);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public boolean previous() throws SQLException {
        this.check_close();
        try {
            return this.rs.previous();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.check_close();
        try {
            this.rs.setFetchDirection(direction);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.check_close();
        try {
            return this.rs.getFetchDirection();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.check_close();
        try {
            this.rs.setFetchSize(rows);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.check_close();
        try {
            return this.rs.getFetchSize();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public int getType() throws SQLException {
        this.check_close();
        try {
            return this.rs.getType();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.check_close();
        try {
            return this.rs.getConcurrency();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.check_close();
        try {
            return this.rs.rowUpdated();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.check_close();
        try {
            return this.rs.rowInserted();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.check_close();
        try {
            return this.rs.rowDeleted();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.check_close();
        try {
            this.rs.updateNull(columnIndex);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateBoolean(columnIndex, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateByte(columnIndex, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateShort(columnIndex, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateInt(columnIndex, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateLong(columnIndex, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateFloat(columnIndex, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateDouble(columnIndex, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateBigDecimal(columnIndex, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateString(columnIndex, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateBytes(columnIndex, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateDate(columnIndex, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateTime(columnIndex, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateTimestamp(columnIndex, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.check_close();
        try {
            this.rs.updateAsciiStream(columnIndex, x, length);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.check_close();
        try {
            this.rs.updateBinaryStream(columnIndex, x, length);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.check_close();
        try {
            this.rs.updateCharacterStream(columnIndex, x, length);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.check_close();
        try {
            this.rs.updateObject(columnIndex, x, scale);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateObject(columnIndex, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        this.check_close();
        try {
            this.rs.updateNull(columnName);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateBoolean(columnName, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateByte(columnName, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateShort(columnName, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateInt(columnName, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateLong(columnName, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateFloat(columnName, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateDouble(columnName, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateBigDecimal(columnName, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateString(columnName, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateBytes(columnName, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateDate(columnName, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateTime(columnName, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateTimestamp(columnName, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.check_close();
        try {
            this.rs.updateAsciiStream(columnName, x, length);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.check_close();
        try {
            this.rs.updateBinaryStream(columnName, x, length);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateCharacterStream(String columnName, Reader x, int length) throws SQLException {
        this.check_close();
        try {
            this.rs.updateCharacterStream(columnName, x, length);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.check_close();
        try {
            this.rs.updateObject(columnName, x, scale);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateObject(columnName, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void insertRow() throws SQLException {
        this.check_close();
        try {
            this.rs.insertRow();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateRow() throws SQLException {
        this.check_close();
        try {
            this.rs.updateRow();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        this.check_close();
        try {
            this.rs.deleteRow();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void refreshRow() throws SQLException {
        this.check_close();
        try {
            this.rs.refreshRow();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.check_close();
        try {
            this.rs.cancelRowUpdates();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.check_close();
        try {
            this.rs.moveToInsertRow();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.check_close();
        try {
            this.rs.moveToCurrentRow();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.check_close();
        return this.wstmt;
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        this.check_close();
        try {
            return this.rs.getObject(i, map);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        this.check_close();
        try {
            return this.rs.getRef(i);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        this.check_close();
        try {
            return this.rs.getBlob(i);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        this.check_close();
        try {
            return this.rs.getClob(i);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Array getArray(int i) throws SQLException {
        this.check_close();
        try {
            return this.rs.getArray(i);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Object getObject(String colName, Map<String, Class<?>> map) throws SQLException {
        this.check_close();
        try {
            return this.rs.getObject(colName, map);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        this.check_close();
        try {
            return this.rs.getRef(colName);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        this.check_close();
        try {
            return this.rs.getBlob(colName);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        this.check_close();
        try {
            return this.rs.getClob(colName);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        this.check_close();
        try {
            return this.rs.getArray(colName);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.check_close();
        try {
            return this.rs.getDate(columnIndex, cal);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        this.check_close();
        try {
            return this.rs.getDate(columnName, cal);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.check_close();
        try {
            return this.rs.getTime(columnIndex, cal);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        this.check_close();
        try {
            return this.rs.getTime(columnName, cal);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.check_close();
        try {
            return this.rs.getTimestamp(columnIndex, cal);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        this.check_close();
        try {
            return this.rs.getTimestamp(columnName, cal);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        this.check_close();
        try {
            return this.rs.getURL(columnIndex);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        this.check_close();
        try {
            return this.rs.getURL(columnName);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateRef(columnIndex, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateRef(columnName, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateBlob(columnIndex, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateBlob(columnName, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateClob(columnIndex, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateClob(columnName, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateArray(columnIndex, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateArray(columnName, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        this.check_close();
        try {
            return this.rs.getRowId(columnIndex);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        this.check_close();
        try {
            return this.rs.getRowId(columnLabel);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateRowId(columnIndex, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateRowId(columnLabel, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        this.check_close();
        try {
            return this.rs.getHoldability();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        this.check_close();
        try {
            return this.rs.isClosed();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        this.check_close();
        try {
            this.rs.updateNString(columnIndex, nString);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        this.check_close();
        try {
            this.rs.updateNString(columnLabel, nString);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.check_close();
        try {
            this.rs.updateNClob(columnIndex, nClob);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        this.check_close();
        try {
            this.rs.updateNClob(columnLabel, nClob);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        this.check_close();
        try {
            return this.rs.getNClob(columnIndex);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        this.check_close();
        try {
            return this.rs.getNClob(columnLabel);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        this.check_close();
        try {
            return this.rs.getSQLXML(columnIndex);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        this.check_close();
        try {
            return this.rs.getSQLXML(columnLabel);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.check_close();
        try {
            this.rs.updateSQLXML(columnIndex, xmlObject);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.check_close();
        try {
            this.rs.updateSQLXML(columnLabel, xmlObject);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        this.check_close();
        try {
            return this.rs.getNString(columnIndex);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        this.check_close();
        try {
            return this.rs.getNString(columnLabel);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        this.check_close();
        try {
            return this.rs.getNCharacterStream(columnIndex);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        this.check_close();
        try {
            return this.rs.getNCharacterStream(columnLabel);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.check_close();
        try {
            this.rs.updateNCharacterStream(columnIndex, x, length);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.check_close();
        try {
            this.rs.updateNCharacterStream(columnLabel, reader, length);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.check_close();
        try {
            this.rs.updateAsciiStream(columnIndex, x, length);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.check_close();
        try {
            this.rs.updateBinaryStream(columnIndex, x, length);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.check_close();
        try {
            this.rs.updateCharacterStream(columnIndex, x, length);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.check_close();
        try {
            this.rs.updateAsciiStream(columnLabel, x, length);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.check_close();
        try {
            this.rs.updateBinaryStream(columnLabel, x, length);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.check_close();
        try {
            this.rs.updateCharacterStream(columnLabel, reader, length);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.check_close();
        try {
            this.rs.updateBlob(columnIndex, inputStream, length);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.check_close();
        try {
            this.rs.updateBlob(columnLabel, inputStream, length);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.check_close();
        try {
            this.rs.updateClob(columnIndex, reader, length);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.check_close();
        try {
            this.rs.updateClob(columnLabel, reader, length);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.check_close();
        try {
            this.rs.updateNClob(columnIndex, reader, length);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.check_close();
        try {
            this.rs.updateNClob(columnLabel, reader, length);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateNCharacterStream(columnIndex, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.check_close();
        try {
            this.rs.updateNCharacterStream(columnLabel, reader);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateAsciiStream(columnIndex, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateBinaryStream(columnIndex, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateCharacterStream(columnIndex, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateAsciiStream(columnLabel, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.check_close();
        try {
            this.rs.updateBinaryStream(columnLabel, x);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.check_close();
        try {
            this.rs.updateCharacterStream(columnLabel, reader);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.check_close();
        try {
            this.rs.updateBlob(columnIndex, inputStream);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.check_close();
        try {
            this.rs.updateBlob(columnLabel, inputStream);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.check_close();
        try {
            this.rs.updateClob(columnIndex, reader);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.check_close();
        try {
            this.rs.updateClob(columnLabel, reader);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.check_close();
        try {
            this.rs.updateNClob(columnIndex, reader);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.check_close();
        try {
            this.rs.updateNClob(columnLabel, reader);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.check_close();
        try {
            return this.rs.unwrap(iface);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.check_close();
        try {
            return this.rs.isWrapperFor(iface);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        this.check_close();
        try {
            return this.rs.getObject(columnIndex, type);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        this.check_close();
        try {
            return this.rs.getObject(columnLabel, type);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    private void check_close() throws SQLException {
        if (this.rs == null) {
            throw new VirtuosoException("The ResultSet is closed.", 0);
        }
    }
}

