/*
 * Decompiled with CFR 0.152.
 */
package openlink.util;

import java.util.Enumeration;
import openlink.util.VectorEnumerator;

public class Vector {
    protected Object[] elementData;
    protected int elementCount;
    protected int capacityIncrement;

    public Vector(int initialCapacity, int capacityIncrement) {
        this.elementData = new Object[initialCapacity];
        this.capacityIncrement = capacityIncrement;
    }

    public Vector(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public Vector() {
        this(10);
    }

    public Vector(Object[] array) {
        this.elementData = array;
        this.elementCount = array.length;
    }

    public void copyInto(Object[] anArray) {
        System.arraycopy(this.elementData, 0, anArray, 0, this.elementCount);
    }

    public void trimToSize() {
        int oldCapacity = this.elementData.length;
        if (this.elementCount < oldCapacity) {
            Object[] oldData = this.elementData;
            this.elementData = new Object[this.elementCount];
            System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
        }
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity > this.elementData.length) {
            this.ensureCapacityHelper(minCapacity);
        }
    }

    private void ensureCapacityHelper(int minCapacity) {
        int newCapacity;
        int oldCapacity = this.elementData.length;
        Object[] oldData = this.elementData;
        int n = newCapacity = this.capacityIncrement > 0 ? oldCapacity + this.capacityIncrement : oldCapacity * 2;
        if (newCapacity < minCapacity) {
            newCapacity = minCapacity;
        }
        this.elementData = new Object[newCapacity];
        System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
    }

    public void setSize(int newSize) {
        if (newSize > this.elementCount && newSize > this.elementData.length) {
            this.ensureCapacityHelper(newSize);
        } else {
            for (int i = newSize; i < this.elementCount; ++i) {
                this.elementData[i] = null;
            }
        }
        this.elementCount = newSize;
    }

    public int capacity() {
        return this.elementData.length;
    }

    public final int size() {
        return this.elementCount;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public Enumeration elements() {
        return new VectorEnumerator(this);
    }

    public boolean contains(Object elem) {
        return this.indexOf(elem, 0) >= 0;
    }

    public int indexOf(Object elem) {
        return this.indexOf(elem, 0);
    }

    public int indexOf(Object elem, int index) {
        for (int i = index; i < this.elementCount; ++i) {
            if (!elem.equals(this.elementData[i])) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(Object elem) {
        return this.lastIndexOf(elem, this.elementCount - 1);
    }

    public int lastIndexOf(Object elem, int index) {
        for (int i = index; i >= 0; --i) {
            if (!elem.equals(this.elementData[i])) continue;
            return i;
        }
        return -1;
    }

    public Object elementAt(int index) {
        return this.elementData[index];
    }

    public Object firstElement() {
        return this.elementData[0];
    }

    public Object lastElement() {
        return this.elementData[this.elementCount - 1];
    }

    public void setElementAt(Object obj, int index) {
        this.elementData[index] = obj;
        if (index >= this.elementCount) {
            this.elementCount = index + 1;
        }
    }

    public void removeElementAt(int index) {
        int j = this.elementCount - index - 1;
        if (j > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, j);
        }
        if (this.elementCount > 0) {
            --this.elementCount;
        }
        this.elementData[this.elementCount] = null;
    }

    public void insertElementAt(Object obj, int index) {
        int newcount = this.elementCount + 1;
        if (newcount > this.elementData.length) {
            this.ensureCapacityHelper(newcount);
        }
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.elementCount - index);
        this.elementData[index] = obj;
        ++this.elementCount;
    }

    public void addElement(Object obj) {
        int newcount = this.elementCount + 1;
        if (newcount > this.elementData.length) {
            this.ensureCapacityHelper(newcount);
        }
        this.elementData[this.elementCount++] = obj;
    }

    public boolean removeElement(Object obj) {
        int i = this.indexOf(obj);
        if (i >= 0) {
            this.removeElementAt(i);
            return true;
        }
        return false;
    }

    public void removeAllElements() {
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = null;
        }
        this.elementCount = 0;
    }

    public String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        Enumeration e = this.elements();
        buf.append("[");
        for (int i = 0; i <= max; ++i) {
            Object obj = e.nextElement();
            String s = obj == null ? "<null>" : obj.toString();
            buf.append(s);
            if (i >= max) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public Object clone() {
        Object[] _new = new Object[this.elementCount];
        System.arraycopy(this.elementData, 0, _new, 0, this.elementCount);
        return new Vector(_new);
    }
}

