/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.mrelib.util;

import cz.zcu.mre.mrelib.MREException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Random;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HashGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(HashGenerator.class);
    private static final Package PACKAGE = HashGenerator.class.getPackage();
    private static final String NO_HASH_VALUE = "--no-hash--";
    public static final String ALGORITHM = "SHA-1";
    public static final int HASH_SIZE = 40;
    private static final int BUFFER_SIZE = 8192;
    private static final byte HALFBYTE_SIZE = 4;
    private static final byte HEX_0F = 15;
    private static final String HEADER = "\n---\nSHA-1 hash generator" + PACKAGE.getImplementationVersion() + " version\n author Petr Vcelak <vcelak@kiv.zcu.cz)\n web    https://mre.zcu.cz/\n---\nSHA-1 hash generator is a tool of MRELib library. It's main purpose is to generate a SHA-1 hash used in URI of RDF data.\n---\nOptions:";
    private static final String FOOTER = "This is free software; see the source for copying conditions. There is NO\nwarranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR\nPURPOSE, to the extent permitted by law.";
    private static final String USAGE = "java -cp ./mrelib-<version>.jar cz.zcu.mre.mrelib.HashGenerator";
    private static File file;
    private static String hash;

    public static void main(String[] args) {
        int exit = 0;
        try {
            HashGenerator.doProcessing(HashGenerator.options(), args);
        }
        catch (MREException ex) {
            if (ex.getExit() != 0 && !StringUtils.isEmpty((CharSequence)ex.getMessage())) {
                LOG.error(null, (Throwable)ex);
            }
            if (ex.isExit()) {
                exit = ex.getExit();
            }
        }
        finally {
            if (StringUtils.isEmpty((CharSequence)hash)) {
                hash = NO_HASH_VALUE;
            }
        }
        System.out.println(hash);
        System.exit(exit);
    }

    private static Options options() {
        Options opts = new Options();
        opts.addOption("h", "help", false, "Print this message.");
        OptionGroup optGroup = new OptionGroup();
        Option.Builder optionBuilder = Option.builder((String)"r");
        optionBuilder.desc("Use random generator for a random hash.");
        optionBuilder.longOpt("random");
        optGroup.addOption(optionBuilder.build());
        optionBuilder = Option.builder((String)"ts");
        optionBuilder.argName("now");
        optionBuilder.desc("Create hash from an actual timestamp. It is based on a Long with 'new Date().getTime()' value.");
        optionBuilder.longOpt("timestamp");
        optGroup.addOption(optionBuilder.build());
        optionBuilder = Option.builder((String)"f");
        optionBuilder.argName("file");
        optionBuilder.hasArg();
        optionBuilder.desc("File's sha1sum.");
        optionBuilder.longOpt("file");
        optGroup.addOption(optionBuilder.build());
        optionBuilder = Option.builder((String)"t");
        optionBuilder.argName("string");
        optionBuilder.hasArg();
        optionBuilder.desc("Create the string hash.");
        optionBuilder.longOpt("text");
        optGroup.addOption(optionBuilder.build());
        optionBuilder = Option.builder((String)"u");
        optionBuilder.argName("string");
        optionBuilder.hasArg();
        optionBuilder.desc("Create unique hash based on all of random generator hash, your string and a timestamp hash.In fact, it calls sha1All(sha1Random() + text + sha1Now())");
        optionBuilder.longOpt("unique");
        optGroup.addOption(optionBuilder.build());
        opts.addOptionGroup(optGroup);
        return opts;
    }

    private static CommandLine doProcessing(Options options, String[] args) throws MREException {
        CommandLine cl = null;
        try {
            cl = new DefaultParser().parse(options, args);
        }
        catch (ParseException e) {
            LOG.error("Missing, invalid or incomplete options.");
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(USAGE, HEADER, options, FOOTER, true);
        }
        if (cl == null) {
            throw new MREException(-1);
        }
        if (cl.hasOption("help")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(USAGE, HEADER, options, FOOTER, true);
            throw new MREException(0);
        }
        if (cl.hasOption("random")) {
            hash = HashGenerator.sha1Random();
        } else if (cl.hasOption("timestamp")) {
            hash = HashGenerator.sha1Now();
        } else if (cl.hasOption("file")) {
            file = new File(cl.getOptionValue("file"));
            if (!file.isFile() || file.canRead()) {
                file = null;
            } else {
                hash = HashGenerator.sha1(file);
            }
        } else if (cl.hasOption("text")) {
            hash = HashGenerator.sha1Text(cl.getOptionValue("text"));
        } else if (cl.hasOption("unique")) {
            hash = HashGenerator.sha1All(cl.getOptionValue("text"));
        } else {
            throw new MREException("Any argument is missing.", -1);
        }
        return cl;
    }

    private static String convertToHex(byte[] data) {
        int partBottom = 9;
        int partTop = 10;
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int twoHalfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (twoHalfs++ < 1);
        }
        return buf.toString();
    }

    public static String sha1Text(String text) {
        byte[] sha1hash = new byte[40];
        if (text == null) {
            throw new NullPointerException("Cannot use null string in sha1Text().");
        }
        try {
            MessageDigest md = MessageDigest.getInstance(ALGORITHM);
            md.update(text.getBytes("UTF-8"), 0, text.length());
            sha1hash = md.digest();
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException ex) {
            LOG.error(null, (Throwable)ex);
        }
        return HashGenerator.convertToHex(sha1hash);
    }

    public static String sha1(File f) {
        byte[] sha1hash = new byte[40];
        try {
            MessageDigest md = MessageDigest.getInstance(ALGORITHM);
            try (FileInputStream is = new FileInputStream(f);){
                int read;
                byte[] buffer = new byte[8192];
                while ((read = ((InputStream)is).read(buffer)) > 0) {
                    md.update(buffer, 0, read);
                }
            }
            sha1hash = md.digest();
        }
        catch (FileNotFoundException ex) {
            LOG.error(null, (Throwable)ex);
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            LOG.error(null, (Throwable)ex);
        }
        return HashGenerator.convertToHex(sha1hash);
    }

    public static String sha1Random() {
        Random generator0 = new Random();
        Random generator1 = new Random(generator0.nextLong() - generator0.nextLong() + new Date().getTime());
        return HashGenerator.sha1Text(Long.toString(generator1.nextLong()));
    }

    public static String sha1Now() {
        return HashGenerator.sha1Text(Long.toString(new Date().getTime()));
    }

    public static String sha1All(String text) {
        return HashGenerator.sha1Text(HashGenerator.sha1Random() + text + HashGenerator.sha1Now());
    }

    private HashGenerator() {
    }

    public static enum TYPE {
        RANDOM,
        TIMESTAMP,
        FILE,
        TEXT,
        UNIQUE;

    }
}

