/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.mrelib.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateUtil {
    private static final Logger LOG = LoggerFactory.getLogger(DateUtil.class);
    public static final String XSD_DATETIME = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String XSD_DATETIME_PATTERN = "\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}";
    public static final String DATETIME_PATTERN = "\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}";
    public static final String XSD_DATETIME_WITH_TZ = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String XSD_DATETIME_WITH_TZ_PATTERN = "\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}([+-]\\d{4})?";
    public static final String XSD_DATE = "yyyy-MM-dd";
    public static final String XSD_DATE_PATTERN = "\\d{4}-\\d{2}-\\d{2}";
    public static final String XSD_TIME = "HH:mm:ss";
    public static final String XSD_TIME_PATTERN = "\\d{2}:\\d{2}:\\d{2}";
    public static final String XSD_TIME_WITH_TZ = "HH:mm:ssZ";
    public static final String XSD_TIME_WITH_TZ_PATTERN = "\\d{2}:\\d{2}:\\d{2}([+-]\\d{4})?";

    public static Date stringToDate(String format, String dateString) {
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.GERMANY);
        formatter.setTimeZone(TimeZone.getDefault());
        Date date = null;
        if (dateString != null && !dateString.isEmpty()) {
            try {
                date = formatter.parse(dateString);
            }
            catch (ParseException ex) {
                LOG.error(null, (Throwable)ex);
            }
        }
        return date;
    }

    public static String xsdDate(Date date) {
        return DateUtil.format(date, XSD_DATETIME);
    }

    public static String format(Date date, String format) {
        Locale locale = new Locale("cs", "CZ");
        if (date != null) {
            SimpleDateFormat formatter = new SimpleDateFormat(format, locale);
            return formatter.format(date);
        }
        return null;
    }

    private DateUtil() {
    }
}

