/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.mrelib.datasource;

import cz.zcu.mre.mrelib.datasource.DataSource;
import cz.zcu.mre.mrelib.datasource.VirtuosoConnection;
import java.util.Properties;
import org.apache.jena.graph.Graph;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import virtuoso.jdbc4.VirtuosoDataSource;

public final class VirtuosoDS
extends VirtuosoDataSource
implements DataSource {
    private static final long serialVersionUID = -768619680078273268L;
    private Properties connectionProperties = null;
    private VirtuosoConnection connection;

    public VirtuosoDS() {
    }

    public VirtuosoDS(Properties properties) {
        this();
        this.connectionProperties = properties;
    }

    private VirtuosoConnection createConnection() {
        if (this.connection == null) {
            this.connection = new VirtuosoConnection(this.connectionProperties.getProperty("url"), this.connectionProperties.getProperty("user"), this.connectionProperties.getProperty("password"));
        }
        return this.connection;
    }

    private VirtuosoConnection createConnection(String name) {
        if (this.connection == null) {
            this.connection = new VirtuosoConnection(name, this.connectionProperties.getProperty("url"), this.connectionProperties.getProperty("user"), this.connectionProperties.getProperty("password"));
        }
        return this.connection;
    }

    @Override
    public void close() {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
        }
    }

    @Override
    public Model createModel(String name) {
        return this.getModel(name);
    }

    @Override
    public Model getModel(String name) {
        return ModelFactory.createModelForGraph((Graph)this.createConnection(name));
    }

    @Override
    public Graph createGraph(String name) {
        return this.createConnection(name);
    }

    @Override
    public Graph getAllGraphs() {
        this.createConnection();
        this.connection.setReadFromAllGraphs(true);
        return this.connection;
    }

    @Override
    public Graph getAllGraph(String mainName) {
        this.createConnection(mainName);
        this.connection.setReadFromAllGraphs(true);
        return this.connection;
    }

    @Override
    public Graph getGraph() {
        return this.createConnection();
    }

    @Override
    public Graph getGraph(String name) {
        return this.createConnection(name);
    }

    public VirtuosoConnection getVirtuosoConnection() {
        return this.connection;
    }

    public void setConnection(VirtuosoConnection virtConnection) {
        this.connection = virtConnection;
    }

    @Override
    public Model getAllModels(String mainModel) {
        return ModelFactory.createModelForGraph((Graph)this.getAllGraph(mainModel));
    }
}

