/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.mrelib.data;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.filter.Filters;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaderSAX2Factory;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLParser
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(XMLParser.class);
    private Document document;

    public final void parseXML(File file) {
        XMLReaderSAX2Factory xmlrjdomf = new XMLReaderSAX2Factory(false, "org.apache.xerces.parsers.SAXParser");
        SAXBuilder saxBuilder = new SAXBuilder((XMLReaderJDOMFactory)xmlrjdomf);
        saxBuilder.setFeature("http://apache.org/xml/features/validation/schema", false);
        saxBuilder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        saxBuilder.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        saxBuilder.setFeature("http://xml.org/sax/features/validation", false);
        saxBuilder.setFeature("http://xml.org/sax/features/resolve-dtd-uris", false);
        try {
            this.document = saxBuilder.build(file);
        }
        catch (IOException | JDOMException ex) {
            LOG.error(null, ex);
        }
    }

    public final Element getNode(Element rootElement, String xpath) {
        XPathFactory xpf = XPathFactory.instance();
        XPathExpression expr = xpf.compile(xpath, Filters.element());
        Element element = (Element)expr.evaluateFirst((Object)rootElement);
        if (element != null) {
            return element;
        }
        return null;
    }

    public final List<Element> nodes(String xpath) {
        XPathFactory xpf = XPathFactory.instance();
        XPathExpression expr = xpf.compile(xpath, Filters.element());
        return expr.evaluate((Object)this.document);
    }

    public final List<Attribute> attributes(Content content) {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        if (content instanceof Element) {
            Element element = (Element)content;
            list.addAll(element.getAttributes());
        }
        return list;
    }

    public final boolean exist(Content content, String xpath) {
        XPathFactory xpf = XPathFactory.instance();
        XPathExpression expr = xpf.compile(xpath, Filters.element());
        Element model = (Element)expr.evaluateFirst((Object)content);
        return model != null && model.getContent() != null && !model.getContent().isEmpty();
    }

    public final boolean exist(String xpath) {
        XPathFactory xpf = XPathFactory.instance();
        XPathExpression expr = xpf.compile(xpath, Filters.element());
        Element model = (Element)expr.evaluateFirst((Object)this.document);
        return model != null && model.getContent() != null && !model.getContent().isEmpty();
    }

    public final List<String> attributeValues(String xpath, String attrName) {
        ArrayList<String> attributeValueList = new ArrayList<String>();
        List<Element> nodes = this.nodes(xpath);
        nodes.stream().forEach(node -> attributeValueList.add(this.attributeValue((Element)node, attrName)));
        return attributeValueList;
    }

    public final String attributeValue(String xpath, String attrName) {
        XPathFactory xpf = XPathFactory.instance();
        XPathExpression expr = xpf.compile(xpath, Filters.element());
        Element model = (Element)expr.evaluateFirst((Object)this.document);
        return model.getAttributeValue(attrName);
    }

    public final String attributeValue(Element element, String attrName) {
        if (element == null || element.getAttribute(attrName) == null) {
            return "";
        }
        return element.getAttribute(attrName).getValue();
    }

    public final String elementValue(String xpath) {
        XPathFactory xpf = XPathFactory.instance();
        XPathExpression expr = xpf.compile(xpath, Filters.element());
        Element model = (Element)expr.evaluateFirst((Object)this.document);
        if (model != null) {
            return model.getText();
        }
        return "";
    }

    public final String elementValue(Content content) {
        String elementValue = "";
        if (content != null) {
            elementValue = content.getValue();
        }
        return elementValue;
    }

    public final String elementValue(Content content, String xpath) {
        XPathFactory xpf = XPathFactory.instance();
        XPathExpression expr = xpf.compile(xpath, Filters.element());
        Element element = (Element)expr.evaluateFirst((Object)content);
        if (element != null) {
            return element.getText();
        }
        return "";
    }

    public final List<String> elementValues(String xpath) {
        ArrayList<String> elementValueList = new ArrayList<String>();
        XPathFactory xpf = XPathFactory.instance();
        XPathExpression expr = xpf.compile(xpath, Filters.element());
        Element element = (Element)expr.evaluateFirst((Object)this.document);
        List le = element.getChildren();
        le.stream().forEach(e -> {
            if (e != null) {
                elementValueList.add(e.getText());
            }
        });
        return elementValueList;
    }
}

