/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.mrelib.data;

import cz.zcu.mre.mrelib.Const;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.tika.Tika;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileTypeDeterminer {
    private static final Logger LOG = LoggerFactory.getLogger(FileTypeDeterminer.class);
    private static final String HEADER_GLUCOSE_ONLY = "Date;Time;BG Reading (mmol/L);Sensor Glucose (mmol/L)";
    private static final String HEADER_PUMP_AND_SENSOR_CARELINK = "Last Name;First Name;Patient ID;Start Date;End Date;;Device;";
    private static final String HEADER_BLOOD_ONLY = "Action\tDate\tTime\tValue\tEvent\tComment";
    private static final String HEADER_GLUCOSE_AND_CARBS = "PatientInfoField\tPatientInfoValue\tGlucoseInternalTime\tGlucoseDisplayTime";
    public static final int DETERMINE_FROM_BYTES = 140;
    public static final Tika TIKA = new Tika();

    public static String determineType(File file) {
        String type;
        String header = FileTypeDeterminer.readFileHeader(file, 140);
        if (FileTypeDeterminer.typeDICOM(header)) {
            type = "dicom";
        } else if (FileTypeDeterminer.typeMEDICALCXML(header)) {
            type = "medicalcxml";
        } else if (FileTypeDeterminer.typeDASTASITS(FileTypeDeterminer.readFileHeader(file, 19600))) {
            type = "dasta_for_medicalcxml";
        } else if (FileTypeDeterminer.typeSITSCSV(header)) {
            type = "sits_csv_downloaded";
        } else if (FileTypeDeterminer.typeDASTA(header)) {
            type = "dasta";
        } else {
            type = FileTypeDeterminer.typeGlucose(header, file);
            if (type == null) {
                try {
                    type = TIKA.detect(file);
                }
                catch (IOException ex) {
                    LOG.error(null, (Throwable)ex);
                }
            }
        }
        LOG.debug("Determined {} type of the {} file", (Object)type, (Object)file.getAbsolutePath());
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFileHeader(File file, int bytes) {
        Reader inputStream = null;
        char[] data = null;
        int length = 0;
        try {
            data = new char[bytes];
            inputStream = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Const.CHARSET));
            length = inputStream.read(data, 0, bytes);
            inputStream.close();
        }
        catch (FileNotFoundException ex) {
            LOG.error(null, (Throwable)ex);
        }
        catch (IOException ex) {
            LOG.error(null, (Throwable)ex);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ex) {
                LOG.error(null, (Throwable)ex);
            }
        }
        if (length == 0) {
            return "";
        }
        return String.valueOf(data);
    }

    public static boolean typeDASTA(String header) {
        return header.contains("DOCTYPE dasta");
    }

    public static boolean typeDASTASITS(String header) {
        return header.contains("DOCTYPE dasta") && header.contains("<nazev>508/000");
    }

    public static boolean typeDICOM(String header) {
        return header.contains("DICM");
    }

    public static boolean typeDTD(String header) {
        return header.contains("DTD") || header.contains("<!ENTITY");
    }

    public static boolean typeSITSCSV(String header) {
        return header.contains("content_id$title_or_id$getProtocol$getCountryId$");
    }

    public static boolean typeMEDICALCXML(String header) {
        String anonmedToCheck = header.replaceAll("<\\?xml.*\\?>", "").replaceAll("\\s+", "");
        return header.contains("DOCTYPE medicalcxml") || anonmedToCheck.matches("<data>.*") || anonmedToCheck.matches("<data><row>.*");
    }

    private static String typeGlucose(String header, File file) {
        String type = null;
        try {
            type = TIKA.detect(file);
        }
        catch (IOException ex) {
            LOG.error(null, (Throwable)ex);
        }
        if (header.contains(HEADER_GLUCOSE_ONLY)) {
            type = "csv_glucose_glucose_only";
        } else if (header.contains(HEADER_PUMP_AND_SENSOR_CARELINK)) {
            type = "csv_glucose_pump_and_sensor_carelink";
        } else if (header.contains(HEADER_BLOOD_ONLY)) {
            type = "csv_glucose_blood_only";
        } else if (header.contains(HEADER_GLUCOSE_AND_CARBS)) {
            type = "csv_glucose_glucose_and_carbs";
        }
        if (type == null) {
            return null;
        }
        switch (type) {
            case "application/vnd.ms-excel": {
                type = "xls_glucose_diasend";
                break;
            }
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet": {
                type = "xlsx_glucose_medtronic_diabetes_ipro";
                break;
            }
        }
        return type;
    }

    private FileTypeDeterminer() {
    }
}

