/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.mrelib.concurent;

import cz.zcu.mre.mrelib.concurent.Farmer;
import cz.zcu.mre.mrelib.concurent.Worker;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractFarmer
implements Farmer {
    private int threadCount = 1;
    private final List<Worker> workers = new ArrayList<Worker>();

    public AbstractFarmer(int count) {
        this.setThreadCount(count);
    }

    private void initializeWorkers() {
        for (int i = 0; i < this.threadCount; ++i) {
            Worker worker = this.createWorker();
            this.workers.add(worker);
        }
    }

    @Override
    public final void runWorkers() {
        this.initializeWorkers();
        this.workers.stream().map(worker -> {
            this.onBeforeStartEvent((Worker)worker);
            return worker;
        }).map(worker -> {
            worker.start();
            return worker;
        }).forEach(worker -> this.onAfterStartEvent((Worker)worker));
        this.onBeforeFarmerEndEvent();
    }

    @Override
    public final int getThreadCount() {
        return this.threadCount;
    }

    @Override
    public final void setThreadCount(int count) {
        this.threadCount = count;
    }

    protected final List<Worker> getWorkers() {
        return this.workers;
    }
}

