/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.anonmed.rule;

import cz.zcu.mre.anonmed.rule.Profile;
import cz.zcu.mre.anonmed.rule.Rule;
import cz.zcu.mre.anonmed.rule.RuleComparator;
import cz.zcu.mre.mrelib.Const;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ProfileBuilder.class);
    private File rulesFile;
    private Map<String, Profile<Rule>> profiles = null;

    public ProfileBuilder(File file) {
        this.setRulesFile(file);
    }

    public final File getRulesFile() {
        return this.rulesFile;
    }

    public final void setRulesFile(File file) {
        if (file == null) {
            throw new NullPointerException("De-identification rules file is null.");
        }
        if (!file.isFile() || !file.canRead()) {
            throw new IllegalArgumentException("De-identification rules file doesn't exist or you do not have read access.");
        }
        this.rulesFile = file;
        LOG.info("PROFILE file is: {}", (Object)file.getAbsolutePath());
        this.createProfiles();
    }

    public final Profile<Rule> getProfile(String type) {
        if (this.profiles == null) {
            this.createProfiles();
        }
        if (this.profiles != null && this.profiles.containsKey(type)) {
            return this.profiles.get(type);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createProfiles() {
        BufferedReader reader = null;
        if (this.profiles == null) {
            this.profiles = new HashMap<String, Profile<Rule>>();
        }
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.rulesFile), Const.CHARSET));
            while ((line = reader.readLine()) != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, "\t");
                String[] row = new String[7];
                int col = 0;
                while (tokenizer.hasMoreTokens()) {
                    row[col++] = tokenizer.nextToken();
                }
                Rule rule = new Rule();
                rule.setAll(row);
                this.appendRule(rule);
            }
        }
        catch (FileNotFoundException e) {
            LOG.error(null, (Throwable)e);
        }
        catch (IOException e) {
            LOG.error(null, (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    LOG.error(null, (Throwable)ex);
                }
            }
        }
        this.profiles.keySet().stream().map(key -> this.profiles.get(key)).forEach(profile -> Collections.sort(profile, new RuleComparator()));
    }

    private void appendRule(Rule rule) {
        LOG.debug("RULE: {}", (Object)rule);
        if (this.profiles.containsKey(rule.getFileType())) {
            this.profiles.get(rule.getFileType()).add(rule);
        } else {
            Profile profile = new Profile(rule.getFileType());
            profile.add(rule);
            this.profiles.put(rule.getFileType(), profile);
        }
    }
}

