/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.anonmed.anonymizer;

import cz.zcu.mre.anonmed.AnonMedConfiguration;
import cz.zcu.mre.anonmed.AnonMedException;
import cz.zcu.mre.anonmed.AnonymousIdentification;
import cz.zcu.mre.anonmed.anonymizer.AbstractAnonymizer;
import cz.zcu.mre.anonmed.rule.Rule;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLSAnonymizer
extends AbstractAnonymizer {
    private static final Logger LOG = LoggerFactory.getLogger(XLSAnonymizer.class);
    public static final int COORDINATES_SIZE = 3;
    public static final int SHEET = 0;
    public static final int COLUMN = 1;
    public static final int ROW = 2;
    private Workbook workbook;
    private String anonymousIdentification;

    public XLSAnonymizer(AnonMedConfiguration config) {
        super(config);
        this.setFileType("application/vnd.ms-excel");
        this.setFileExtension("xls");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void fileOpen(File file) {
        this.anonymousIdentification = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            try {
                this.workbook = new HSSFWorkbook((InputStream)fis);
            }
            catch (OfficeXmlFileException office) {
                fis = new FileInputStream(file);
                this.workbook = new XSSFWorkbook((InputStream)fis);
            }
            this.setActiveFile(file);
        }
        catch (FileNotFoundException ex) {
            LOG.error("File {} not found. {}", (Object)file.getAbsolutePath(), (Object)ex.getMessage());
        }
        catch (IOException ex) {
            LOG.error("IOException {} {}", (Object)file.getAbsolutePath(), (Object)ex.getMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    LOG.error(null, (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void fileWrite(String filename) throws AnonMedException {
        File file = new File(filename);
        if (!this.getConfig().isOverwriteFile().booleanValue() && file.exists()) {
            throw new AnonMedException("Overwrite not allowed and the output file '" + file.getAbsolutePath() + "' exists", -1);
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            this.workbook.write((OutputStream)fos);
        }
        catch (FileNotFoundException ex) {
            LOG.error("File {} not found. {}", (Object)file.getAbsolutePath(), (Object)ex.getMessage());
        }
        catch (IOException ex) {
            LOG.error("IOException {} {}", (Object)file.getAbsolutePath(), (Object)ex.getMessage());
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ex) {
                LOG.error(null, (Throwable)ex);
            }
        }
    }

    @Override
    public final void ruleAppendAfter(Rule rule) {
        Object[] id = this.rule2Coordinates(rule);
        if (!this.canAnonymize(rule, id)) {
            return;
        }
        Sheet sheet = this.workbook.getSheet((String)id[0]);
        String oldValue = this.getCellStringValue(sheet.getRow(((Integer)id[2]).intValue()).getCell(((Integer)id[1]).intValue()));
        String newValue = oldValue + rule.getNewValue();
        if (rule.getCondition() != null && rule.getCondition().equals("toString")) {
            sheet.getRow(((Integer)id[2]).intValue()).getCell(((Integer)id[1]).intValue()).setCellType(CellType.STRING);
        }
        this.report(rule, oldValue, newValue);
        this.setCellStringValue(sheet.getRow(((Integer)id[2]).intValue()).getCell(((Integer)id[1]).intValue()), newValue);
    }

    @Override
    public final void ruleAppendBefore(Rule rule) {
        Object[] id = this.rule2Coordinates(rule);
        if (!this.canAnonymize(rule, id)) {
            return;
        }
        Sheet sheet = this.workbook.getSheet((String)id[0]);
        String oldValue = this.getCellStringValue(sheet.getRow(((Integer)id[2]).intValue()).getCell(((Integer)id[1]).intValue()));
        String newValue = rule.getNewValue() + oldValue;
        if (rule.getCondition() != null && rule.getCondition().equals("toString")) {
            sheet.getRow(((Integer)id[2]).intValue()).getCell(((Integer)id[1]).intValue()).setCellType(CellType.STRING);
        }
        this.report(rule, oldValue, newValue);
        this.setCellStringValue(sheet.getRow(((Integer)id[2]).intValue()).getCell(((Integer)id[1]).intValue()), newValue);
    }

    @Override
    public final void ruleEmpty(Rule rule) {
        Object[] id = this.rule2Coordinates(rule);
        if (!this.canAnonymize(rule, id)) {
            return;
        }
        Sheet sheet = this.workbook.getSheet((String)id[0]);
        String oldValue = this.getCellStringValue(sheet.getRow(((Integer)id[2]).intValue()).getCell(((Integer)id[1]).intValue()));
        this.report(rule, oldValue, "[EMPTY]");
        this.setCellStringValue(sheet.getRow(((Integer)id[2]).intValue()).getCell(((Integer)id[1]).intValue()), "");
    }

    @Override
    public final void ruleChange(Rule rule) {
        Object[] id = this.rule2Coordinates(rule);
        if (!this.canAnonymize(rule, id)) {
            return;
        }
        Sheet sheet = this.workbook.getSheet((String)id[0]);
        String oldValue = this.getCellStringValue(sheet.getRow(((Integer)id[2]).intValue()).getCell(((Integer)id[1]).intValue()));
        this.report(rule, oldValue, rule.getNewValue());
        this.setCellStringValue(sheet.getRow(((Integer)id[2]).intValue()).getCell(((Integer)id[1]).intValue()), rule.getNewValue());
    }

    @Override
    public final void ruleIdentification(Rule rule) {
        Object[] id = this.rule2Coordinates(rule);
        if (!this.canAnonymize(rule, id)) {
            return;
        }
        Sheet sheet = this.workbook.getSheet((String)id[0]);
        String oldValue = this.getCellStringValue(sheet.getRow(((Integer)id[2]).intValue()).getCell(((Integer)id[1]).intValue()));
        if (this.anonymousIdentification == null) {
            this.anonymousIdentification = AnonymousIdentification.anonymize(oldValue);
        }
        this.report(rule, oldValue, this.anonymousIdentification);
        this.setCellStringValue(sheet.getRow(((Integer)id[2]).intValue()).getCell(((Integer)id[1]).intValue()), this.anonymousIdentification);
    }

    @Override
    public final void ruleKeep(Rule rule) {
    }

    @Override
    public final void ruleRemove(Rule rule) {
        Object[] id = this.rule2Coordinates(rule);
        if (!this.canAnonymize(rule, id)) {
            return;
        }
        Sheet sheet = this.workbook.getSheet((String)id[0]);
        String oldValue = this.getCellStringValue(sheet.getRow(((Integer)id[2]).intValue()).getCell(((Integer)id[1]).intValue()));
        this.report(rule, oldValue, "[REMOVED]");
        this.setCellStringValue(sheet.getRow(((Integer)id[2]).intValue()).getCell(((Integer)id[1]).intValue()), "");
    }

    @Override
    public final void ruleSpecific(Rule rule) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void strictMode() {
    }

    @Override
    public void ruleDecrypt(Rule rule) {
        Object[] id = this.rule2Coordinates(rule);
        if (!this.canAnonymize(rule, id)) {
            return;
        }
        Sheet sheet = this.workbook.getSheet((String)id[0]);
        String oldValue = this.getCellStringValue(sheet.getRow(((Integer)id[2]).intValue()).getCell(((Integer)id[1]).intValue()));
        String newValue = this.makeDecrypt(rule, oldValue);
        if (rule.getCondition() != null && rule.getCondition().equals("toString")) {
            sheet.getRow(((Integer)id[2]).intValue()).getCell(((Integer)id[1]).intValue()).setCellType(CellType.STRING);
        }
        this.report(rule, oldValue, newValue);
        this.setCellStringValue(sheet.getRow(((Integer)id[2]).intValue()).getCell(((Integer)id[1]).intValue()), newValue);
    }

    @Override
    public void ruleEncrypt(Rule rule) {
        Object[] id = this.rule2Coordinates(rule);
        if (!this.canAnonymize(rule, id)) {
            return;
        }
        Sheet sheet = this.workbook.getSheet((String)id[0]);
        String oldValue = this.getCellStringValue(sheet.getRow(((Integer)id[2]).intValue()).getCell(((Integer)id[1]).intValue()));
        String newValue = this.makeEncrypt(rule, oldValue);
        if (rule.getCondition() != null && rule.getCondition().equals("toString")) {
            sheet.getRow(((Integer)id[2]).intValue()).getCell(((Integer)id[1]).intValue()).setCellType(CellType.STRING);
        }
        this.report(rule, oldValue, newValue);
        this.setCellStringValue(sheet.getRow(((Integer)id[2]).intValue()).getCell(((Integer)id[1]).intValue()), newValue);
    }

    protected final Object[] rule2Coordinates(Rule rule) {
        Object[] id = new Object[3];
        String[] s = rule.getRule().split(",");
        id[0] = s[0];
        id[2] = Integer.parseInt(s[2]) - 1;
        id[1] = Integer.parseInt(s[1]) - 1;
        return id;
    }

    protected final boolean canAnonymize(Rule rule, Object[] id) {
        return this.workbook.getSheet((String)id[0]) != null;
    }

    protected final String getCellStringValue(Cell cell) {
        String value = null;
        switch (cell.getCellType()) {
            case BLANK: {
                break;
            }
            case BOOLEAN: {
                value = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case ERROR: {
                break;
            }
            case FORMULA: {
                break;
            }
            case NUMERIC: {
                value = String.valueOf(cell.getNumericCellValue());
                break;
            }
            case STRING: {
                value = String.valueOf(cell.getStringCellValue());
                break;
            }
        }
        return value;
    }

    protected final void setCellStringValue(Cell cell, Object value) {
        if (value instanceof String) {
            cell.setCellType(CellType.STRING);
            cell.setCellValue((String)value);
        } else if (value instanceof Integer) {
            cell.setCellType(CellType.NUMERIC);
            cell.setCellValue((double)((Integer)value).intValue());
        } else if (value instanceof Float || value instanceof Double) {
            cell.setCellType(CellType.NUMERIC);
            cell.setCellValue(((Double)value).doubleValue());
        } else if (value instanceof Boolean) {
            cell.setCellType(CellType.BOOLEAN);
            cell.setCellValue(((Boolean)value).booleanValue());
        } else {
            cell.setCellType(CellType.STRING);
            cell.setCellValue(value.toString());
        }
    }

    @Override
    public void ruleSubstitute(Rule rule) {
        Object[] id = this.rule2Coordinates(rule);
        if (!this.canAnonymize(rule, id)) {
            return;
        }
        Sheet sheet = this.workbook.getSheet((String)id[0]);
        String oldValue = this.getCellStringValue(sheet.getRow(((Integer)id[2]).intValue()).getCell(((Integer)id[1]).intValue()));
        String newValue = this.makeSubstitute(rule, oldValue);
        if (rule.getCondition() != null && rule.getCondition().equals("toString")) {
            sheet.getRow(((Integer)id[2]).intValue()).getCell(((Integer)id[1]).intValue()).setCellType(CellType.STRING);
        }
        this.report(rule, oldValue, newValue);
        this.setCellStringValue(sheet.getRow(((Integer)id[2]).intValue()).getCell(((Integer)id[1]).intValue()), newValue);
    }

    @Override
    public void ruleSubstring(Rule rule) {
        Object[] id = this.rule2Coordinates(rule);
        if (!this.canAnonymize(rule, id)) {
            return;
        }
        Sheet sheet = this.workbook.getSheet((String)id[0]);
        String oldValue = this.getCellStringValue(sheet.getRow(((Integer)id[2]).intValue()).getCell(((Integer)id[1]).intValue()));
        String newValue = this.makeSubstring(rule, oldValue);
        if (rule.getCondition() != null && rule.getCondition().equals("toString")) {
            sheet.getRow(((Integer)id[2]).intValue()).getCell(((Integer)id[1]).intValue()).setCellType(CellType.STRING);
        }
        this.report(rule, oldValue, newValue);
        this.setCellStringValue(sheet.getRow(((Integer)id[2]).intValue()).getCell(((Integer)id[1]).intValue()), newValue);
    }

    @Override
    public void ruleLowercase(Rule rule) {
        Object[] id = this.rule2Coordinates(rule);
        if (!this.canAnonymize(rule, id)) {
            return;
        }
        Sheet sheet = this.workbook.getSheet((String)id[0]);
        String oldValue = this.getCellStringValue(sheet.getRow(((Integer)id[2]).intValue()).getCell(((Integer)id[1]).intValue()));
        String newValue = this.makeLowercase(rule, oldValue);
        if (rule.getCondition() != null && rule.getCondition().equals("toString")) {
            sheet.getRow(((Integer)id[2]).intValue()).getCell(((Integer)id[1]).intValue()).setCellType(CellType.STRING);
        }
        this.report(rule, oldValue, newValue);
        this.setCellStringValue(sheet.getRow(((Integer)id[2]).intValue()).getCell(((Integer)id[1]).intValue()), newValue);
    }

    @Override
    public void ruleUppercase(Rule rule) {
        Object[] id = this.rule2Coordinates(rule);
        if (!this.canAnonymize(rule, id)) {
            return;
        }
        Sheet sheet = this.workbook.getSheet((String)id[0]);
        String oldValue = this.getCellStringValue(sheet.getRow(((Integer)id[2]).intValue()).getCell(((Integer)id[1]).intValue()));
        String newValue = this.makeUppercase(rule, oldValue);
        if (rule.getCondition() != null && rule.getCondition().equals("toString")) {
            sheet.getRow(((Integer)id[2]).intValue()).getCell(((Integer)id[1]).intValue()).setCellType(CellType.STRING);
        }
        this.report(rule, oldValue, newValue);
        this.setCellStringValue(sheet.getRow(((Integer)id[2]).intValue()).getCell(((Integer)id[1]).intValue()), newValue);
    }
}

