/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.anonmed.anonymizer;

import cz.zcu.mre.anonmed.AnonMedConfiguration;
import cz.zcu.mre.anonmed.AnonMedException;
import cz.zcu.mre.anonmed.AnonymousIdentification;
import cz.zcu.mre.anonmed.anonymizer.AbstractAnonymizer;
import cz.zcu.mre.anonmed.anonymizer.VRMap;
import cz.zcu.mre.anonmed.rule.Rule;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.imageio.plugins.dcm.DicomMetaData;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.io.DicomOutputStream;
import org.dcm4che3.util.SafeClose;
import org.dcm4che3.util.TagUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DicomAnonymizer
extends AbstractAnonymizer {
    private static final Logger LOG = LoggerFactory.getLogger(DicomAnonymizer.class);
    private DicomMetaData dicomMetaData;
    private Attributes metadata;
    private String anonymousIdentification;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final DicomMetaData openDicomFile(File file) {
        DicomMetaData dmd = null;
        DicomInputStream dis = null;
        try {
            dis = new DicomInputStream(file);
            dis.setIncludeBulkData(DicomInputStream.IncludeBulkData.URI);
            Attributes dcmMetadata = dis.readFileMetaInformation();
            Attributes dcmDataset = dis.readDataset();
            dmd = new DicomMetaData(dcmMetadata, dcmDataset);
            for (int i : dmd.getAttributes().tags()) {
                LOG.debug("File {} has tag {}", (Object)file.getAbsoluteFile(), (Object)TagUtils.toHexString((int)i));
            }
        }
        catch (IOException ex) {
            try {
                LOG.error(null, (Throwable)ex);
            }
            catch (Throwable throwable) {
                SafeClose.close(dis);
                throw throwable;
            }
            SafeClose.close((Closeable)dis);
        }
        SafeClose.close((Closeable)dis);
        return dmd;
    }

    public static int stringToTag(String tagAsString) {
        int tag = Integer.decode("0x" + tagAsString.replace(",", ""));
        return tag;
    }

    public DicomAnonymizer(AnonMedConfiguration config) {
        super(config);
        this.setFileType("dicom");
        this.setFileExtension("dcm");
    }

    @Override
    public final void fileOpen(File file) {
        this.anonymousIdentification = null;
        this.setUncertain(Boolean.FALSE);
        this.dicomMetaData = DicomAnonymizer.openDicomFile(file);
        if (this.dicomMetaData != null) {
            this.setActiveFile(file);
            this.metadata = this.dicomMetaData.getAttributes();
        } else {
            LOG.info("IGNORE file {} -- no metadata", (Object)file.getAbsolutePath());
            this.setActiveFile(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void fileWrite(String filename) throws AnonMedException {
        File file = new File(filename);
        if (!this.getConfig().isOverwriteFile().booleanValue() && file.exists()) {
            throw new AnonMedException("Overwrite not allowed and the output file '" + file.getAbsolutePath() + "' exists", -1);
        }
        DicomOutputStream dos = null;
        try {
            dos = new DicomOutputStream(file);
            dos.writeDataset(this.dicomMetaData.getFileMetaInformation(), this.dicomMetaData.getAttributes());
        }
        catch (IOException e) {
            try {
                LOG.error("Error writing DICOM file {}", (Object)file.getAbsolutePath(), (Object)e);
            }
            catch (Throwable throwable) {
                SafeClose.close(dos);
                throw throwable;
            }
            SafeClose.close((Closeable)dos);
        }
        SafeClose.close((Closeable)dos);
    }

    @Override
    public final void ruleAppendAfter(Rule rule) {
        if (!this.metadata.containsValue(DicomAnonymizer.stringToTag(rule.getRule()))) {
            return;
        }
        String oldValue = this.metadata.getString(DicomAnonymizer.stringToTag(rule.getRule()));
        String newValue = oldValue.concat(rule.getNewValue());
        this.report(rule, oldValue, newValue);
        this.metadata.setString(DicomAnonymizer.stringToTag(rule.getRule()), VRMap.valueOf(rule.getCondition()).getVR(), newValue);
    }

    @Override
    public final void ruleAppendBefore(Rule rule) {
        if (!this.metadata.containsValue(DicomAnonymizer.stringToTag(rule.getRule()))) {
            return;
        }
        String oldValue = this.metadata.getString(DicomAnonymizer.stringToTag(rule.getRule()));
        String newValue = rule.getNewValue().concat(oldValue);
        this.report(rule, oldValue, newValue);
        this.metadata.setString(DicomAnonymizer.stringToTag(rule.getRule()), VRMap.valueOf(rule.getCondition()).getVR(), newValue);
    }

    @Override
    public final void ruleChange(Rule rule) {
        if (!this.metadata.containsValue(DicomAnonymizer.stringToTag(rule.getRule()))) {
            return;
        }
        String oldValue = this.metadata.getString(DicomAnonymizer.stringToTag(rule.getRule()));
        String newValue = rule.getNewValue();
        this.report(rule, oldValue, newValue);
        this.metadata.setString(DicomAnonymizer.stringToTag(rule.getRule()), VRMap.valueOf(rule.getCondition()).getVR(), newValue);
    }

    @Override
    public final void ruleEmpty(Rule rule) {
        if (!this.metadata.containsValue(DicomAnonymizer.stringToTag(rule.getRule()))) {
            return;
        }
        String oldValue = this.metadata.getString(DicomAnonymizer.stringToTag(rule.getRule()));
        this.report(rule, oldValue, "[EMPTY]");
        this.metadata.setNull(DicomAnonymizer.stringToTag(rule.getRule()), VRMap.valueOf(rule.getCondition()).getVR());
    }

    @Override
    public final void ruleIdentification(Rule rule) {
        if (!this.metadata.containsValue(DicomAnonymizer.stringToTag(rule.getRule()))) {
            return;
        }
        int tag = DicomAnonymizer.stringToTag(rule.getRule());
        VR oldVR = this.metadata.getVR(DicomAnonymizer.stringToTag(rule.getRule()));
        String oldValue = this.metadata.getString(tag);
        if (this.anonymousIdentification == null) {
            this.anonymousIdentification = AnonymousIdentification.anonymize(oldValue);
        }
        this.report(rule, oldValue, this.anonymousIdentification);
        this.metadata.setString(DicomAnonymizer.stringToTag(rule.getRule()), oldVR, this.anonymousIdentification);
    }

    @Override
    public final void ruleRemove(Rule rule) {
        if (!this.metadata.containsValue(DicomAnonymizer.stringToTag(rule.getRule()))) {
            return;
        }
        String oldValue = this.metadata.getString(DicomAnonymizer.stringToTag(rule.getRule()));
        this.report(rule, oldValue, "[REMOVED]");
        this.metadata.remove(DicomAnonymizer.stringToTag(rule.getRule()));
    }

    @Override
    public final void ruleSpecific(Rule rule) {
        String oldValue;
        if (rule.getRule().equals("removePrivateTags")) {
            for (int tag : this.metadata.tags()) {
                if (!TagUtils.isPrivateTag((int)tag)) continue;
                String oldValue2 = this.metadata.getString(tag);
                this.report(rule, oldValue2, "[REMOVED]");
                this.metadata.remove(tag);
            }
        }
        if (rule.getRule().equals("00280301") && this.metadata.containsValue(DicomAnonymizer.stringToTag(rule.getRule())) && (oldValue = this.metadata.getString(DicomAnonymizer.stringToTag(rule.getRule()))) != null && rule.getNewValue() != null && oldValue.equals(rule.getNewValue())) {
            this.report(rule, oldValue, "[METAMED_SET_UNCERTAIN_FLAG]");
            this.setUncertain(Boolean.TRUE);
        }
    }

    @Override
    public void strictMode() {
    }

    @Override
    public void ruleDecrypt(Rule rule) {
        if (!this.metadata.containsValue(DicomAnonymizer.stringToTag(rule.getRule()))) {
            return;
        }
        String oldValue = this.metadata.getString(DicomAnonymizer.stringToTag(rule.getRule()));
        String newValue = this.makeDecrypt(rule, oldValue);
        this.report(rule, oldValue, newValue);
        this.metadata.setString(DicomAnonymizer.stringToTag(rule.getRule()), VRMap.valueOf(rule.getCondition()).getVR(), newValue);
    }

    @Override
    public void ruleEncrypt(Rule rule) {
        if (!this.metadata.containsValue(DicomAnonymizer.stringToTag(rule.getRule()))) {
            return;
        }
        String oldValue = this.metadata.getString(DicomAnonymizer.stringToTag(rule.getRule()));
        String newValue = this.makeEncrypt(rule, oldValue);
        this.report(rule, oldValue, newValue);
        this.metadata.setString(DicomAnonymizer.stringToTag(rule.getRule()), VRMap.valueOf(rule.getCondition()).getVR(), newValue);
    }

    @Override
    public void ruleSubstitute(Rule rule) {
        if (!this.metadata.containsValue(DicomAnonymizer.stringToTag(rule.getRule()))) {
            return;
        }
        String oldValue = this.metadata.getString(DicomAnonymizer.stringToTag(rule.getRule()));
        String newValue = this.makeSubstitute(rule, oldValue);
        this.report(rule, oldValue, newValue);
        this.metadata.setString(DicomAnonymizer.stringToTag(rule.getRule()), VRMap.valueOf(rule.getCondition()).getVR(), newValue);
    }

    @Override
    public void ruleSubstring(Rule rule) {
        if (!this.metadata.containsValue(DicomAnonymizer.stringToTag(rule.getRule()))) {
            return;
        }
        String oldValue = this.metadata.getString(DicomAnonymizer.stringToTag(rule.getRule()));
        String newValue = this.makeSubstring(rule, oldValue);
        this.report(rule, oldValue, newValue);
        this.metadata.setString(DicomAnonymizer.stringToTag(rule.getRule()), VRMap.valueOf(rule.getCondition()).getVR(), newValue);
    }

    @Override
    public void ruleLowercase(Rule rule) {
        if (!this.metadata.containsValue(DicomAnonymizer.stringToTag(rule.getRule()))) {
            return;
        }
        String oldValue = this.metadata.getString(DicomAnonymizer.stringToTag(rule.getRule()));
        String newValue = this.makeLowercase(rule, oldValue);
        this.report(rule, oldValue, newValue);
        this.metadata.setString(DicomAnonymizer.stringToTag(rule.getRule()), VRMap.valueOf(rule.getCondition()).getVR(), newValue);
    }

    @Override
    public void ruleUppercase(Rule rule) {
        if (!this.metadata.containsValue(DicomAnonymizer.stringToTag(rule.getRule()))) {
            return;
        }
        String oldValue = this.metadata.getString(DicomAnonymizer.stringToTag(rule.getRule()));
        String newValue = this.makeUppercase(rule, oldValue);
        this.report(rule, oldValue, newValue);
        this.metadata.setString(DicomAnonymizer.stringToTag(rule.getRule()), VRMap.valueOf(rule.getCondition()).getVR(), newValue);
    }
}

