/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.anonmed;

import cz.zcu.mre.anonmed.AnonMedConfiguration;
import cz.zcu.mre.anonmed.AnonMedException;
import cz.zcu.mre.anonmed.AnonymizerMap;
import cz.zcu.mre.anonmed.AnonymousIdentification;
import cz.zcu.mre.anonmed.DefaultAnonymizerMap;
import cz.zcu.mre.anonmed.anonymizer.Anonymizer;
import cz.zcu.mre.anonmed.rule.ProfileBuilder;
import cz.zcu.mre.mrelib.cipher.DefaultCipherServiceImpl;
import cz.zcu.mre.mrelib.cipher.KeyDatabase;
import cz.zcu.mre.mrelib.data.FileTypeDeterminer;
import java.io.File;
import java.util.Collections;
import java.util.Date;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnonMed {
    private static final Logger LOG = LoggerFactory.getLogger(AnonMed.class);
    public static final Package PACKAGE = AnonMed.class.getPackage();
    private static final String USAGE = "java -jar anonmed [options] INPUT [INPUT...]\n";
    private static final String HEADER = "\n---\nAnonMed v" + PACKAGE.getImplementationVersion() + "\nauthor Petr Vcelak <vcelak@kiv.zcu.cz)\nweb    https://mre.zcu.cz/anonmed\n---\n\nAnonMed is an universal automatic/non-interactive rules-based\nanonymization/de-identification application\nfor heterogeneous data.\n\nOptions:\n\n";
    private static final String FOOTER = "Example:\n\n* Modify all supported files from inputdata/ based on configuration in the profiles.csv, person identification is in a database.csv file map. A new person gets an identification based on a sequence-number.txt file of number generator. Results are stored to the output/ directory and uncertainly modified files to the output-uncertain/ directory.\n\nanonmed --overwrite --profiles profiles.csv   --identificator-mapping database.csv  --sequence-number sequence-number.txt --output output/  --uncertain output-uncertain/ inputdata/\n\nThis is free software; see the source for copying conditions. There is NO\nwarranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR\nPURPOSE, to the extent permitted by law.\n\n\n";
    private static final AnonMedConfiguration CONFIG = new AnonMedConfiguration();
    private static AnonymizerMap anonymizers;

    public static void main(String[] args) throws Exception {
        block3: {
            try {
                AnonMed.parseCommandLine(AnonMed.options(), args);
                KeyDatabase keyDB = new KeyDatabase();
                keyDB.setAlgorighmSymmetric("AES");
                keyDB.setAlgorithmAsymmetric("RSA");
                keyDB.setAlgorithmAsymmetricSize(4096);
                KeyDatabase.setPassword(CONFIG.getPassword());
                keyDB.setPrincipal("CN=AnonMed, OU=medical.zcu.cz, O=ZCU, C=CS");
                DefaultCipherServiceImpl cipherService = new DefaultCipherServiceImpl(keyDB);
                cipherService.setContext(CONFIG.getContext());
                CONFIG.setCipherService(cipherService);
                anonymizers = new DefaultAnonymizerMap(CONFIG);
                LOG.info("AnonMed start.");
                long milliseconds0 = new Date().getTime();
                CONFIG.getInputFiles().stream().forEach(f -> AnonMed.anonymizeFile(f, anonymizers));
                long milliseconds1 = new Date().getTime();
                LOG.info("AnonMed processing finished in {} milliseconds", (Object)(milliseconds1 - milliseconds0));
            }
            catch (AnonMedException e) {
                if (e.getExit() != 0 && !StringUtils.isEmpty((CharSequence)e.getMessage())) {
                    System.err.println(e.getMessage());
                }
                if (!e.isExit()) break block3;
                System.exit(e.getExit());
            }
        }
    }

    private static Options options() {
        Options opts = new Options();
        opts.addOption("h", "help", false, "Print this message.");
        Option.Builder optionBuilder = Option.builder((String)"p");
        optionBuilder.longOpt("profiles");
        optionBuilder.argName("profileFile");
        optionBuilder.hasArg();
        optionBuilder.required();
        optionBuilder.desc("File with profiles description.");
        opts.addOption(optionBuilder.build());
        optionBuilder = Option.builder((String)"i");
        optionBuilder.argName("identFile");
        optionBuilder.hasArg();
        optionBuilder.required();
        optionBuilder.desc("Identification's mapping database file (required). The file (CSV format) maps private  person's identification to an anonymization application's unique sequence number.");
        optionBuilder.longOpt("identification-mapping");
        opts.addOption(optionBuilder.build());
        optionBuilder = Option.builder((String)"s");
        optionBuilder.argName("seqFile");
        optionBuilder.hasArg();
        optionBuilder.required();
        optionBuilder.desc("A file with next available sequence number (required). It contains single line with that number.");
        optionBuilder.longOpt("sequence-number");
        opts.addOption(optionBuilder.build());
        optionBuilder = Option.builder((String)"u");
        optionBuilder.argName("dir");
        optionBuilder.hasArg();
        optionBuilder.required();
        optionBuilder.desc("Uncertain anonymization output directory .");
        optionBuilder.longOpt("uncertain");
        opts.addOption(optionBuilder.build());
        optionBuilder = Option.builder((String)"d");
        optionBuilder.argName("file");
        optionBuilder.hasArgs();
        optionBuilder.desc("Files to anonymize.");
        optionBuilder.longOpt("data");
        opts.addOption(optionBuilder.build());
        optionBuilder = Option.builder();
        optionBuilder.longOpt("delete-original");
        optionBuilder.desc("Delete original file.");
        optionBuilder.required(false);
        opts.addOption(optionBuilder.build());
        optionBuilder = Option.builder();
        optionBuilder.longOpt("overwrite");
        optionBuilder.desc("Overwrite file. Be careful an original or output file can be overwriten.");
        optionBuilder.required(false);
        opts.addOption(optionBuilder.build());
        optionBuilder = Option.builder((String)"r");
        optionBuilder.longOpt("rename-filename");
        optionBuilder.desc("Rename a file on an output.");
        optionBuilder.required(false);
        opts.addOption(optionBuilder.build());
        optionBuilder = Option.builder((String)"o");
        optionBuilder.argName("dir");
        optionBuilder.hasArg();
        optionBuilder.desc("Output directory.");
        optionBuilder.longOpt("output");
        opts.addOption(optionBuilder.build());
        optionBuilder = Option.builder((String)"ks");
        optionBuilder.argName("dir");
        optionBuilder.hasArg();
        optionBuilder.desc("KeyStore directory.");
        optionBuilder.longOpt("keystore");
        optionBuilder.required(false);
        opts.addOption(optionBuilder.build());
        optionBuilder = Option.builder((String)"pwd");
        optionBuilder.argName("pass");
        optionBuilder.hasArg();
        optionBuilder.required(false);
        optionBuilder.desc("Password to the key store.");
        optionBuilder.longOpt("password");
        opts.addOption(optionBuilder.build());
        optionBuilder = Option.builder((String)"c");
        optionBuilder.argName("ctx");
        optionBuilder.hasArg();
        optionBuilder.required(false);
        optionBuilder.desc("AnonMed run in the named context.");
        optionBuilder.longOpt("context");
        opts.addOption(optionBuilder.build());
        opts.addOption(null, "strict-mode", false, "Enables strict mode. Data (attributes, elements, tags, cells) not mentioned in any rule are automatically removed. Use KEEP rule when no other rule is useful to keep data in the file in the strict mode. (<experimental>; not implemented in all anonymizers)");
        return opts;
    }

    private static CommandLine parseCommandLine(Options options, String[] args) throws AnonMedException {
        CommandLine cl;
        block27: {
            cl = null;
            try {
                cl = new DefaultParser().parse(options, args);
            }
            catch (ParseException e) {
                if (cl != null) break block27;
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp(USAGE, HEADER, options, FOOTER, true);
                throw new AnonMedException("Please, use the help above. " + e.getMessage(), -1);
            }
        }
        if (cl.hasOption("help")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(USAGE, HEADER, options, FOOTER, true);
            throw new AnonMedException(0);
        }
        if (cl.hasOption("change-filename")) {
            LOG.info("SET rename files");
            CONFIG.setChangeFilename(Boolean.TRUE);
        }
        if (cl.hasOption("delete-original")) {
            LOG.info("SET delete the original file");
            CONFIG.setDeleteOriginal(Boolean.TRUE);
        }
        if (cl.hasOption("identification-mapping")) {
            File databaseSource = new File(cl.getOptionValue("identification-mapping"));
            LOG.info("IDENTIFICATION MAPPING file {}", (Object)databaseSource.getAbsolutePath());
            if (!databaseSource.exists()) {
                throw new AnonMedException("File with identification mapping  " + databaseSource.getAbsolutePath() + " does not exist.", -1);
            }
            AnonymousIdentification.setDatabaseSource(databaseSource);
        }
        if (cl.hasOption("sequence-number")) {
            File sequenceNumberSource = new File(cl.getOptionValue("sequence-number"));
            LOG.info("SEQUENCE NUMBER file {}", (Object)sequenceNumberSource.getAbsolutePath());
            if (!sequenceNumberSource.exists()) {
                throw new AnonMedException("File with sequence number " + sequenceNumberSource.getAbsolutePath() + " does not exist.", -1);
            }
            AnonymousIdentification.setSequenceSource(sequenceNumberSource);
        }
        if (cl.hasOption("output")) {
            CONFIG.setOutputDirectory(new File(cl.getOptionValue("output")));
            LOG.info("OUTPUT directory is {}", (Object)CONFIG.getOutputDirectory().getAbsolutePath());
            if (!CONFIG.getOutputDirectory().exists()) {
                throw new AnonMedException("Output directory " + CONFIG.getOutputDirectory().getAbsolutePath() + " does not exist.", -1);
            }
        }
        if (cl.hasOption("keystore")) {
            CONFIG.setKeystoresDirectory(new File(cl.getOptionValue("keystore")));
            LOG.info("KEYSTORE directory is {}", (Object)CONFIG.getKeystoresDirectory().getAbsolutePath());
            if (!CONFIG.getOutputDirectory().exists()) {
                throw new AnonMedException("Keystore directory " + CONFIG.getKeystoresDirectory().getAbsolutePath() + " does not exist.", -1);
            }
        }
        if (cl.hasOption("password")) {
            CONFIG.setPassword(cl.getOptionValue("password"));
            LOG.info("KEYSTORE password were set");
        }
        if (cl.hasOption("context")) {
            CONFIG.setContext(cl.getOptionValue("context"));
            LOG.info("CONTEXT were set to {}", (Object)CONFIG.getContext());
        }
        if (cl.hasOption("uncertain")) {
            CONFIG.setUncertainDirectory(new File(cl.getOptionValue("uncertain")));
            LOG.info("UNCERTAIN output directory is {}", (Object)CONFIG.getUncertainDirectory().getAbsolutePath());
            if (!CONFIG.getUncertainDirectory().exists()) {
                throw new AnonMedException("Uncertain output directory " + CONFIG.getUncertainDirectory().getAbsolutePath() + " does not exist.", -1);
            }
        }
        if (cl.hasOption("overwrite")) {
            LOG.info("OVERWRITE output file flag is set");
            CONFIG.setOverwriteFile(Boolean.TRUE);
        }
        if (cl.hasOption("strict-mode")) {
            LOG.info("STRICT mode enabled");
            CONFIG.setStrictMode(Boolean.TRUE);
        }
        if (CONFIG.getOutputDirectory() == null && !CONFIG.isOverwriteFile().booleanValue()) {
            throw new AnonMedException("No output directory specified and not allowed to overwrite input files.", -1);
        }
        if (CONFIG.getOutputDirectory() == null && CONFIG.isOverwriteFile().booleanValue() && CONFIG.isDeleteOriginal().booleanValue()) {
            throw new AnonMedException("You want to modify an original file, but  you have to delete original file later. Sorry, it is not OK to me.", -1);
        }
        if (cl.hasOption("profiles")) {
            CONFIG.setProfileBuilder(new ProfileBuilder(new File(cl.getOptionValue("profiles"))));
        }
        if (cl.hasOption("data")) {
            for (String s : cl.getOptionValues("data")) {
                File file = new File(s);
                AnonMed.addInputs(file);
            }
        }
        for (Object s : cl.getArgList()) {
            File file = new File((String)s);
            AnonMed.addInputs(file);
        }
        if (CONFIG.getInputFiles().isEmpty()) {
            throw new AnonMedException("Missing any input file", -1);
        }
        if ((CONFIG.getInputFiles().size() > 1 || CONFIG.getInputFiles().size() == 1 && CONFIG.getInputFiles().get(0).isDirectory()) && !CONFIG.isOverwriteFile().booleanValue() && !CONFIG.getOutputDirectory().isDirectory()) {
            throw new AnonMedException("More than one input file without overwrite option needs output directory, not an output file.", -1);
        }
        Collections.sort(CONFIG.getInputFiles());
        return cl;
    }

    public static void addInputs(File input) {
        if (input == null) {
            return;
        }
        if (input.isDirectory()) {
            LOG.debug("DIRECTORY {}", (Object)input.getAbsolutePath());
            File[] listFiles = input.listFiles();
            if (listFiles != null) {
                for (File file : listFiles) {
                    AnonMed.addInputs(file);
                }
            }
        } else if (input.exists()) {
            AnonMed.addInputFile(input);
        }
    }

    private static void addInputFile(File file) {
        if (!file.canRead()) {
            LOG.error("No read access to file {}", (Object)file.getAbsolutePath());
            return;
        }
        if (CONFIG.isOverwriteFile().booleanValue() && !file.canWrite()) {
            LOG.error("Cannot write file {} with overwrite-original file mode enabled.", (Object)file.getAbsolutePath());
            return;
        }
        LOG.info("ADD input file {}", (Object)file.getAbsolutePath());
        CONFIG.getInputFiles().add(file);
    }

    public static File anonymizeFile(File file, AnonymizerMap anonymizerMap) throws AnonMedException {
        String fileType = FileTypeDeterminer.determineType(file);
        LOG.info("FILE\t{}\t{}", (Object)fileType, (Object)file.getAbsolutePath());
        if (anonymizerMap.containsKey(fileType)) {
            return ((Anonymizer)anonymizerMap.get(fileType)).anonymize(file);
        }
        return null;
    }

    private AnonMed() {
    }
}

