/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.exec;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.Syntax;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.QueryEngineFactory;
import org.apache.jena.sparql.engine.QueryEngineRegistry;
import org.apache.jena.sparql.engine.Timeouts;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecBuilder;
import org.apache.jena.sparql.exec.QueryExecDataset;
import org.apache.jena.sparql.exec.QueryExecMod;
import org.apache.jena.sparql.syntax.syntaxtransform.QueryTransformOps;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.ContextAccumulator;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.sys.JenaSystem;

public class QueryExecDatasetBuilder
implements QueryExecMod,
QueryExecBuilder {
    private static final long UNSET = -1L;
    private DatasetGraph dataset = null;
    private Query query = null;
    private String queryString = null;
    private ContextAccumulator contextAcc = ContextAccumulator.newBuilder(() -> ARQ.getContext(), () -> Context.fromDataset(this.dataset));
    private Map<Var, Node> substitutionMap = null;
    private Binding initialBinding = null;
    private Timeouts.TimeoutBuilderImpl timeoutBuilder = new Timeouts.TimeoutBuilderImpl();

    public static QueryExecDatasetBuilder create() {
        QueryExecDatasetBuilder builder = new QueryExecDatasetBuilder();
        return builder;
    }

    private QueryExecDatasetBuilder() {
    }

    public Query getQuery() {
        return this.query;
    }

    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public QueryExecDatasetBuilder query(Query query) {
        this.query = query;
        return this;
    }

    @Override
    public QueryExecDatasetBuilder query(String queryString) {
        this.query(queryString, Syntax.syntaxARQ);
        return this;
    }

    @Override
    public QueryExecDatasetBuilder parseCheck(boolean parseCheck) {
        return this;
    }

    @Override
    public QueryExecDatasetBuilder query(String queryString, Syntax syntax) {
        this.queryString = queryString;
        this.query = QueryFactory.create(queryString, syntax);
        return this;
    }

    public QueryExecDatasetBuilder dataset(DatasetGraph dsg) {
        this.dataset = dsg;
        return this;
    }

    public QueryExecDatasetBuilder graph(Graph graph) {
        DatasetGraph dsg = DatasetGraphFactory.wrap(graph);
        this.dataset(dsg);
        return this;
    }

    @Override
    public QueryExecDatasetBuilder set(Symbol symbol, Object value) {
        this.contextAcc.set(symbol, value);
        return this;
    }

    @Override
    public QueryExecDatasetBuilder set(Symbol symbol, boolean value) {
        this.contextAcc.set(symbol, value);
        return this;
    }

    @Override
    public QueryExecDatasetBuilder context(Context cxt) {
        this.contextAcc.context(cxt);
        return this;
    }

    @Override
    public Context getContext() {
        return this.contextAcc.context();
    }

    @Override
    public QueryExecDatasetBuilder substitution(Binding binding) {
        this.ensureSubstitutionMap();
        binding.forEach(this.substitutionMap::put);
        return this;
    }

    @Override
    public QueryExecDatasetBuilder substitution(Var var, Node value) {
        this.ensureSubstitutionMap();
        this.substitutionMap.put(var, value);
        return this;
    }

    private void ensureSubstitutionMap() {
        if (this.substitutionMap == null) {
            this.substitutionMap = new HashMap<Var, Node>();
        }
    }

    @Deprecated(forRemoval=true)
    public QueryExecDatasetBuilder initialBinding(Binding binding) {
        this.initialBinding = binding;
        return this;
    }

    @Override
    public QueryExecDatasetBuilder timeout(long timeout) {
        return this.timeout(timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public QueryExecDatasetBuilder timeout(long timeout, TimeUnit timeUnit) {
        this.timeoutBuilder.timeout(timeout, timeUnit);
        return this;
    }

    @Override
    public QueryExecDatasetBuilder initialTimeout(long timeout, TimeUnit timeUnit) {
        this.timeoutBuilder.initialTimeout(timeout, timeUnit);
        return this;
    }

    @Override
    public QueryExecDatasetBuilder overallTimeout(long timeout, TimeUnit timeUnit) {
        this.timeoutBuilder.overallTimeout(timeout, timeUnit);
        return this;
    }

    @Override
    public QueryExec build() {
        Objects.requireNonNull(this.query, "No query for QueryExec");
        this.query.setResultVars();
        Context cxt = this.getContext();
        QueryEngineFactory qeFactory = QueryEngineRegistry.findFactory(this.query, this.dataset, cxt);
        if (qeFactory == null) {
            Log.warn(QueryExecDatasetBuilder.class, (String)"Failed to find a QueryEngineFactory");
            return null;
        }
        Query queryActual = this.query;
        String queryStringActual = this.queryString;
        if (this.substitutionMap != null && !this.substitutionMap.isEmpty()) {
            queryActual = QueryTransformOps.replaceVars(this.query, this.substitutionMap);
            queryStringActual = null;
        }
        Timeouts.applyDefaultQueryTimeoutFromContext(this.timeoutBuilder, cxt);
        if (this.dataset != null) {
            cxt.set(ARQConstants.sysCurrentDataset, DatasetFactory.wrap(this.dataset));
        }
        if (queryActual != null) {
            cxt.set(ARQConstants.sysCurrentQuery, queryActual);
        }
        Timeouts.Timeout timeout = this.timeoutBuilder.build();
        QueryExecDataset qExec = new QueryExecDataset(queryActual, queryStringActual, this.dataset, cxt, qeFactory, timeout, this.initialBinding);
        return qExec;
    }

    static {
        JenaSystem.init();
    }
}

