/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.langtag;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.jena.langtag.LangTagException;

class InternalLangTag {
    InternalLangTag() {
    }

    static List<String> splitOnDash(String x) {
        ArrayList<String> strings = new ArrayList<String>(6);
        StringBuilder sb = new StringBuilder();
        boolean start = true;
        for (int idx = 0; idx < x.length(); ++idx) {
            char ch = x.charAt(idx);
            if (InternalLangTag.isA2ZN(ch)) {
                sb.append(ch);
                continue;
            }
            if (ch == '-') {
                String str = sb.toString();
                strings.add(str);
                sb.setLength(0);
                continue;
            }
            InternalLangTag.error("Bad character: (0x%02X) '%c' index %d", ch, InternalLangTag.str(ch), idx);
        }
        String strLast = sb.toString();
        if (strLast.isEmpty()) {
            return null;
        }
        strings.add(strLast);
        return strings;
    }

    static String strcase(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 2) {
            return InternalLangTag.uppercase(string);
        }
        if (string.length() == 4) {
            return InternalLangTag.titlecase(string);
        }
        return InternalLangTag.lowercase(string);
    }

    static String lowercase(String string) {
        if (string == null) {
            return null;
        }
        return string.toLowerCase(Locale.ROOT);
    }

    static String uppercase(String string) {
        if (string == null) {
            return null;
        }
        return string.toUpperCase(Locale.ROOT);
    }

    static String titlecase(String string) {
        if (string == null) {
            return null;
        }
        char ch1 = string.charAt(0);
        ch1 = Character.toUpperCase(ch1);
        string = InternalLangTag.lowercase(string.substring(1));
        return ch1 + string;
    }

    static boolean isA2Z(int ch) {
        return InternalLangTag.range(ch, 'a', 'z') || InternalLangTag.range(ch, 'A', 'Z');
    }

    static boolean isA2ZN(int ch) {
        return InternalLangTag.range(ch, 'a', 'z') || InternalLangTag.range(ch, 'A', 'Z') || InternalLangTag.range(ch, '0', '9');
    }

    static void checkDigits(String string, int N, int start, int end) {
        for (int i = start; i < end; ++i) {
            char ch = string.charAt(i);
            if (InternalLangTag.isNum(ch)) continue;
            InternalLangTag.error("Not a DIGIT (%s, posn = %s) in '%s'", InternalLangTag.str(ch), i + 1, string);
        }
    }

    static void checkAlpha(String string, int N, int start, int end) {
        for (int i = start; i < end; ++i) {
            char ch = string.charAt(i);
            if (InternalLangTag.isAlpha(ch)) continue;
            InternalLangTag.error("Not an ALPHA (%s, posn = %s) in '%s'", InternalLangTag.str(ch), i + 1, string);
        }
    }

    static boolean isAlpha(String string, int start, int end) {
        for (int i = start; i < end; ++i) {
            char ch = string.charAt(i);
            if (InternalLangTag.isAlpha(ch)) continue;
            return false;
        }
        return true;
    }

    static void checkAlphaMinus(String string, int N, int start, int end) {
        for (int i = start; i < end; ++i) {
            char ch = string.charAt(i);
            if (InternalLangTag.isAlpha(ch) || InternalLangTag.isMinus(ch)) continue;
            InternalLangTag.error("Not an ALPHA or MINUS (%s, posn = %s) in '%s'", InternalLangTag.str(ch), i + 1, string);
        }
    }

    static void checkAlphaNum(String string, int N, int start, int end) {
        for (int i = start; i < end; ++i) {
            char ch = string.charAt(i);
            if (InternalLangTag.isAlpha(ch) || InternalLangTag.isNum(ch)) continue;
            InternalLangTag.error("Not an ALPHA or DIGITS (%s, posn = %s) in '%s'", InternalLangTag.str(ch), i + 1, string);
        }
    }

    static void checkAlphaNumMinus(String string, int N, int start, int end) {
        for (int i = start; i < end; ++i) {
            char ch = string.charAt(i);
            if (InternalLangTag.isAlpha(ch) || InternalLangTag.isNum(ch) || InternalLangTag.isMinus(ch)) continue;
            InternalLangTag.error("Not an ALPHA, DIGITS or MINUS (%s, posn = %s) in '%s'", InternalLangTag.str(ch), i + 1, string);
        }
    }

    static String str(char ch) {
        return String.format("'%s' U+%04X", Character.valueOf(ch), (int)ch);
    }

    static boolean isAlpha(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z';
    }

    static boolean isNum(char ch) {
        return ch >= '0' && ch <= '9';
    }

    static boolean isMinus(char ch) {
        return ch == '-';
    }

    static void error(String msg, Object ... args) {
        String x = String.format(msg, args);
        throw new LangTagException(x);
    }

    private static boolean range(int ch, char a, char b) {
        return ch >= a && ch <= b;
    }

    static boolean caseInsensitivePrefix(String string, String prefix) {
        return string.regionMatches(true, 0, prefix, 0, prefix.length());
    }
}

