/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.imageio.codec;

import org.dcm4che3.data.Attributes;
import org.dcm4che3.image.Overlays;
import org.dcm4che3.image.PhotometricInterpretation;

public final class ImageDescriptor {
    private final int rows;
    private final int columns;
    private final int samples;
    private final PhotometricInterpretation photometricInterpretation;
    private final int bitsAllocated;
    private final int bitsStored;
    private final int bitsCompressed;
    private final int pixelRepresentation;
    private final String sopClassUID;
    private final String bodyPartExamined;
    private final int frames;
    private final int[] embeddedOverlays;
    private final int planarConfiguration;

    public ImageDescriptor(Attributes attrs) {
        this(attrs, 0);
    }

    public ImageDescriptor(Attributes attrs, int bitsCompressed) {
        this.rows = attrs.getInt(2621456, 0);
        this.columns = attrs.getInt(2621457, 0);
        this.samples = attrs.getInt(0x280002, 0);
        this.photometricInterpretation = PhotometricInterpretation.fromString((String)attrs.getString(2621444, "MONOCHROME2"));
        this.bitsAllocated = attrs.getInt(2621696, 8);
        this.bitsStored = attrs.getInt(2621697, this.bitsAllocated);
        this.pixelRepresentation = attrs.getInt(2621699, 0);
        this.planarConfiguration = attrs.getInt(2621446, 0);
        this.sopClassUID = attrs.getString(524310);
        this.bodyPartExamined = attrs.getString(1572885);
        this.frames = attrs.getInt(0x280008, 1);
        this.embeddedOverlays = Overlays.getEmbeddedOverlayGroupOffsets((Attributes)attrs);
        this.bitsCompressed = Math.min(this.bitsAllocated, Math.max(this.bitsStored, bitsCompressed < 0 && this.isSigned() ? -bitsCompressed : bitsCompressed));
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getSamples() {
        return this.samples;
    }

    public PhotometricInterpretation getPhotometricInterpretation() {
        return this.photometricInterpretation;
    }

    public int getBitsAllocated() {
        return this.bitsAllocated;
    }

    public int getBitsStored() {
        return this.bitsStored;
    }

    public int getBitsCompressed() {
        return this.bitsCompressed;
    }

    public int getPixelRepresentation() {
        return this.pixelRepresentation;
    }

    public int getPlanarConfiguration() {
        return this.planarConfiguration;
    }

    public String getSopClassUID() {
        return this.sopClassUID;
    }

    public String getBodyPartExamined() {
        return this.bodyPartExamined;
    }

    public int getFrames() {
        return this.frames;
    }

    public boolean isMultiframe() {
        return this.frames > 1;
    }

    public int getFrameLength() {
        return this.rows * this.columns * this.samples * this.bitsAllocated / 8;
    }

    public int getLength() {
        return this.getFrameLength() * this.frames;
    }

    public boolean isSigned() {
        return this.pixelRepresentation != 0;
    }

    public boolean isBanded() {
        return this.planarConfiguration != 0;
    }

    public int[] getEmbeddedOverlays() {
        return this.embeddedOverlays;
    }

    public boolean isMultiframeWithEmbeddedOverlays() {
        return this.embeddedOverlays.length > 0 && this.frames > 1;
    }

    public boolean is16BitsAllocated8BitsStored() {
        return this.bitsAllocated == 16 && this.bitsStored == 8;
    }
}

